import { jsx as _jsx } from "react/jsx-runtime";
import React from "react";
import FormErrorsWrapper from "../FormErrorsWrapper/FormErrorsWrapper";
import { FormOpenedState } from "../../../api";
class ErrorBoundary extends React.Component {
    constructor(props) {
        super(props);
        this.state = { error: undefined, errorInfo: undefined };
    }
    componentDidCatch(error, errorInfo) {
        this.setState({
            error: error,
            errorInfo: errorInfo,
        });
    }
    render() {
        if (this.state.error) {
            setTimeout(() => {
                this.props.notifyOnError({
                    state: FormOpenedState.ERROR,
                    size: {
                        height: document.body.scrollHeight,
                        width: document.body.scrollWidth,
                    },
                });
            }, 500);
            return _jsx(FormErrorsWrapper, { error: this.state.error });
        }
        return this.props.children;
    }
}
export default ErrorBoundary;
//# sourceMappingURL=ErrorBoundary.js.map