import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useMemo, useRef } from "react";
const DmnEditorContext = React.createContext({});
export function useDmnEditor() {
    return useContext(DmnEditorContext);
}
export function DmnEditorContextProvider(props) {
    const dmnModelBeforeEditingRef = useRef(props.model);
    const dmnEditorRootElementRef = useRef(null);
    const value = useMemo(() => ({
        dmnModelBeforeEditingRef,
        dmnEditorRootElementRef,
        externalContextDescription: props.externalContextDescription,
        externalContextName: props.externalContextName,
        issueTrackerHref: props.issueTrackerHref,
        onRequestToJumpToPath: props.onRequestToJumpToPath,
        onRequestToResolvePath: props.onRequestToResolvePath,
        evaluationResultsByNodeId: props.evaluationResultsByNodeId,
    }), [
        props.externalContextDescription,
        props.externalContextName,
        props.issueTrackerHref,
        props.onRequestToJumpToPath,
        props.onRequestToResolvePath,
        props.evaluationResultsByNodeId,
    ]);
    return _jsx(DmnEditorContext.Provider, { value: value, children: props.children });
}
//# sourceMappingURL=DmnEditorContext.js.map