import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { DatePicker } from "@patternfly/react-core/dist/js/components/DatePicker";
import "./Constraint.css";
import "./ConstraintDate.css";
import moment from "moment";
export function ConstraintDate({ value, onChange, isValid }) {
    return (_jsx(_Fragment, { children: _jsx(DatePicker, { className: `kie-dmn-editor--constraint-date kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-date-invalid"}`, inputProps: { className: "kie-dmn-editor--constraint-input" }, value: value, onChange: (e, value) => {
                if (moment(value, "YYYY-MM-DD", true).isValid()) {
                    onChange(value);
                }
            }, onBlur: (e, value) => {
                if (moment(value, "YYYY-MM-DD", true).isValid()) {
                    onChange(value);
                }
            } }) }));
}
//# sourceMappingURL=ConstraintDate.js.map