import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo, useCallback, useEffect } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import "./Constraint.css";
export const REGEX_DATE_TIME_DURATION = /^P(?!$)((-)?\d+D)?(T(?=(-)?\d)((-)?\d+H)?((-)?\d+M)?((-)?\d+S)?)?$/;
export function ConstraintDateTimeDuration({ id, value, onChange, focusOwner, setFocusOwner, isValid, isDisabled, }) {
    const days = useMemo(() => getDaysDuration(value), [value]);
    const hours = useMemo(() => getHoursDuration(value), [value]);
    const minutes = useMemo(() => getMinutesDuration(value), [value]);
    const seconds = useMemo(() => getSecondsDuration(value), [value]);
    useEffect(() => {
        var _a;
        if (focusOwner) {
            (_a = document.getElementById(focusOwner)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [focusOwner]);
    const onInternalChange = useCallback((args) => {
        var _a, _b, _c, _d, _e, _f, _g, _h;
        const d = ((_a = args.days) !== null && _a !== void 0 ? _a : days) ? ((_b = args.days) !== null && _b !== void 0 ? _b : days) + "D" : "";
        const h = ((_c = args.hours) !== null && _c !== void 0 ? _c : hours) ? ((_d = args.hours) !== null && _d !== void 0 ? _d : hours) + "H" : "";
        const m = ((_e = args.minutes) !== null && _e !== void 0 ? _e : minutes) ? ((_f = args.minutes) !== null && _f !== void 0 ? _f : minutes) + "M" : "";
        const s = ((_g = args.seconds) !== null && _g !== void 0 ? _g : seconds) ? ((_h = args.seconds) !== null && _h !== void 0 ? _h : seconds) + "S" : "";
        const t = h || m || s ? "T" : "";
        const p = d || h || m || s ? "P" : "";
        onChange(`${p}${d}${t}${h}${m}${s}`);
    }, [days, hours, minutes, onChange, seconds]);
    const onDaysChange = useCallback((newValue, e) => {
        onInternalChange({ days: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    const onHoursChange = useCallback((newValue, e) => {
        onInternalChange({ hours: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    const onMinutesChange = useCallback((newValue, e) => {
        onInternalChange({ minutes: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    const onSecondsChange = useCallback((newValue, e) => {
        onInternalChange({ seconds: newValue });
        setFocusOwner === null || setFocusOwner === void 0 ? void 0 : setFocusOwner(e.currentTarget.id);
    }, [onInternalChange, setFocusOwner]);
    return (_jsx(_Fragment, { children: _jsxs("div", { style: { display: "flex", flexDirection: "row" }, children: [_jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "D:" }), _jsx(TextInput, { id: `${id}-constraint-days`, type: "number", placeholder: "Days", className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: days, onChange: onDaysChange, isDisabled: isDisabled, autoFocus: true })] }), _jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "H:" }), _jsx(TextInput, { id: `${id}-constraint-hours`, type: "number", placeholder: "Hours", className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: hours, onChange: onHoursChange, isDisabled: isDisabled })] }), _jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "M:" }), _jsx(TextInput, { id: `${id}-constraint-minutes`, type: "number", placeholder: "Minutes", className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: minutes, onChange: onMinutesChange, isDisabled: isDisabled })] }), _jsxs("div", { style: { display: "flex", flexDirection: "row", alignItems: "center", justifyContent: "center" }, children: [_jsx("p", { children: "S:" }), _jsx(TextInput, { id: `${id}-constraint-seconds`, type: "number", placeholder: "Seconds", className: `kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, value: seconds, onChange: onSecondsChange, isDisabled: isDisabled })] })] }) }));
}
function getDaysDuration(value) {
    if (!value.includes("D")) {
        return "";
    }
    const days = value.replace("P", "").split("D")[0];
    if (days.length >= 1) {
        return !isNaN(parseInt(days)) ? days : "";
    }
    return "";
}
function getHoursDuration(value) {
    if (!value.includes("T") || !value.includes("H")) {
        return "";
    }
    let hours = value.replace("P", "").replace("T", "").split("H")[0];
    if (hours.includes("D")) {
        hours = hours.split("D")[1];
    }
    if (hours.length >= 1) {
        return !isNaN(parseInt(hours)) ? hours : "";
    }
    return "";
}
function getMinutesDuration(value) {
    if (!value.includes("T") || !value.includes("M")) {
        return "";
    }
    let hours = value.replace("P", "").replace("T", "").split("M")[0];
    if (hours.includes("D")) {
        hours = hours.split("D")[1];
    }
    if (hours.includes("H")) {
        hours = hours.split("H")[1];
    }
    if (hours.length >= 1) {
        return !isNaN(parseInt(hours)) ? hours : "";
    }
    return "";
}
function getSecondsDuration(value) {
    if (!value.includes("T") || !value.includes("S")) {
        return "";
    }
    let hours = value.replace("P", "").replace("T", "").split("S")[0];
    if (hours.includes("D")) {
        hours = hours.split("D")[1];
    }
    if (hours.includes("H")) {
        hours = hours.split("H")[1];
    }
    if (hours.includes("M")) {
        hours = hours.split("M")[1];
    }
    if (hours.length >= 1) {
        return !isNaN(parseInt(hours)) ? hours : "";
    }
    return "";
}
//# sourceMappingURL=ConstraintDateTimeDuration.js.map