import { graphStructure } from "./graphStructure";
export function checkIsValidConnection(nodesById, edgeOrConnection, ongoingConnectionEdgeType) {
    if (!edgeOrConnection.source || !edgeOrConnection.target) {
        return false;
    }
    const sourceNode = nodesById.get(edgeOrConnection.source);
    const targetNode = nodesById.get(edgeOrConnection.target);
    return _checkIsValidConnection(sourceNode, targetNode, ongoingConnectionEdgeType !== null && ongoingConnectionEdgeType !== void 0 ? ongoingConnectionEdgeType : edgeOrConnection.sourceHandle);
}
export function _checkIsValidConnection(sourceNode, targetNode, edgeType, extraArg) {
    var _a, _b, _c, _d;
    if (!(sourceNode === null || sourceNode === void 0 ? void 0 : sourceNode.type) || !(targetNode === null || targetNode === void 0 ? void 0 : targetNode.type) || !edgeType) {
        return false;
    }
    const targetsExternalNode = targetNode.data.dmnObjectQName.prefix !== undefined;
    const allowExternalTarget = (_a = extraArg === null || extraArg === void 0 ? void 0 : extraArg.allowExternalTarget) !== null && _a !== void 0 ? _a : false;
    if (targetsExternalNode && !allowExternalTarget) {
        return false;
    }
    const ret = (_d = (_c = (_b = graphStructure
        .get(sourceNode.type)) === null || _b === void 0 ? void 0 : _b.get(edgeType)) === null || _c === void 0 ? void 0 : _c.has(targetNode.type)) !== null && _d !== void 0 ? _d : false;
    return ret;
}
//# sourceMappingURL=isValidConnection.js.map