import { DMN15__tDefinitions } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { Unpacked } from "../../tsExt/tsExt";
export type AdjMatrix = Record<string, undefined | Record<string, undefined | {
    direction: HierarchyDirection;
    edge: DrgEdge;
}>>;
export type HierarchyDirection = "up" | "down";
export type DrgEdge = {
    sourceId: string;
    targetId: string;
    id: string;
    dmnObject: {
        namespace: string;
        id: string;
        type: Unpacked<Normalized<DMN15__tDefinitions>["artifact" | "drgElement"]>["__$$element"];
        requirementType: "informationRequirement" | "knowledgeRequirement" | "authorityRequirement" | "association";
        index: number;
    };
};
export type DrgAdjacencyList = Map<string, {
    dependencies: Set<string>;
}>;
export declare function getAdjMatrix(edges: DrgEdge[]): AdjMatrix;
export type NodeVisitor = (nodeId: string, traversalDirection: HierarchyDirection) => void;
export type EdgeVisitor = (edge: DrgEdge, traversalDirection: HierarchyDirection) => void;
export declare function traverse(__adjMatrix: AdjMatrix, originalStartingNodeIds: Set<string>, curNodeIds: string[], traversalDirection: HierarchyDirection, nodeVisitor?: NodeVisitor, edgeVisitor?: EdgeVisitor, visited?: Set<string>): void;
export declare function buildHierarchy({ nodeId, edges }: {
    nodeId: string | undefined | null;
    edges: DrgEdge[];
}): {
    dependencies: Set<string>;
    dependents: Set<string>;
};
//# sourceMappingURL=graph.d.ts.map