import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { DEFAULT_INTRACTION_WIDTH } from "../maths/DmnMaths";
import { DEFAULT_NODE_FILL, DEFAULT_NODE_STROKE_COLOR, DEFAULT_NODE_STROKE_WIDTH } from "./NodeStyle";
export const ___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches = { flag: false };
export function normalize(_props) {
    const { strokeWidth: _strokeWidth, x: _x, y: _y, width: _width, height: _height, fillColor: _fillColor, strokeColor: _strokeColor, ...props } = _props;
    const strokeWidth = _strokeWidth !== null && _strokeWidth !== void 0 ? _strokeWidth : DEFAULT_NODE_STROKE_WIDTH;
    const halfStrokeWidth = strokeWidth / 2;
    const x = _x + halfStrokeWidth;
    const y = _y + halfStrokeWidth;
    const width = _width - strokeWidth;
    const height = _height - strokeWidth;
    return {
        strokeWidth,
        x,
        y,
        width: width + (___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag ? 0.1 : 0),
        height: height + (___NASTY_HACK_FOR_SAFARI_to_force_redrawing_svgs_and_avoid_repaint_glitches.flag ? 0 : 0.1),
        fillColor: _fillColor,
        strokeColor: _strokeColor,
        props,
    };
}
export function InputDataNodeSvg(__props) {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: { isCollection, ...props }, } = normalize(__props);
    const rx = typeof height === "number"
        ? height / 2
        : (() => {
            throw new Error("Can't calculate rx based on a string height.");
        })();
    const ry = typeof width === "number"
        ? width / 2
        : (() => {
            throw new Error("Can't calculate ry based on a string width.");
        })();
    return (_jsxs(_Fragment, { children: [_jsx("rect", { ...props, x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, rx: rx, ry: ry }), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "bottom" }))] }));
}
export function AlternativeInputDataNodeSvg(__props) {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: { isCollection, isIcon, ...props }, } = normalize(__props);
    const bevel = 25;
    const arrowStartingX = 6;
    const arrowStartingY = 10;
    return (_jsxs(_Fragment, { children: [_jsx("polygon", { ...props, points: `0,0 0,${height} ${width},${height} ${width},${bevel} ${width - bevel},0 ${width - bevel},0`, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: isIcon ? __props.transform : `translate(${x},${y})` }), isIcon === false && (_jsxs(_Fragment, { children: [_jsx("polygon", { ...props, points: `${width - bevel},0 ${width - bevel},${bevel} ${width},${bevel}`, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: `translate(${x},${y})` }), _jsx("polygon", { ...props, points: `${arrowStartingX},${arrowStartingY} ${arrowStartingX},20 20,20 20,26 30,15 20,4 20,${arrowStartingY} `, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, transform: `translate(${x},${y})` })] })), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "bottom" }))] }));
}
export function DecisionNodeSvg(__props) {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: { isCollection, hasHiddenRequirements, ...props }, } = normalize(__props);
    return (_jsxs(_Fragment, { children: [_jsx("rect", { x: x, y: y, strokeWidth: strokeWidth, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", ...props }), isCollection && (_jsx(NodeCollectionMarker, { x: x, y: y, width: width, height: height, fillColor: fillColor, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "top" })), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: height, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "middle" }))] }));
}
export function BkmNodeSvg(__props) {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: { hasHiddenRequirements, ...props }, } = normalize(__props);
    const bevel = 25;
    return (_jsxs(_Fragment, { children: [_jsx("polygon", { ...props, points: `${bevel},0 0,${bevel} 0,${height} ${width - bevel},${height} ${width},${height - bevel}, ${width},0`, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: `translate(${x},${y})` }), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: height, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "middle" }))] }));
}
export function KnowledgeSourceNodeSvg(__props) {
    const { strokeWidth, x, y, width, height: totalHeight, fillColor, strokeColor, props: { hasHiddenRequirements, ...props }, } = normalize(__props);
    const amplitude = 20;
    const height = totalHeight - amplitude / 2;
    const straightLines = `M${width},${height} L${width},0 L0,0 L0,${height}`;
    const bottomWave = `Q${width / 4},${height + amplitude} ${width / 2},${height} T${width},${height}`;
    return (_jsxs(_Fragment, { children: [_jsx("path", { ...props, d: `${straightLines} ${bottomWave} Z`, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: `translate(${x},${y})` }), hasHiddenRequirements && (_jsx(NodeHiddenRequirementMarker, { x: x, y: y, width: width, height: totalHeight, strokeColor: strokeColor, strokeWidth: strokeWidth, anchor: "left" }))] }));
}
export const containerNodeInteractionRectCssClassName = "kie-dmn-editor--node-containerNodeInteractionRect";
export const DecisionServiceNodeSvg = React.forwardRef((__props, ref) => {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: _props } = normalize(__props);
    const { strokeWidth: interactionRectStrokeWidth, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, props: _interactionRectProps, } = normalize({ ...__props, strokeWidth: DEFAULT_INTRACTION_WIDTH / 2 });
    const { dividerLineLocalY, showSectionLabels, dividerLineRef, isCollapsed, isReadOnly, ...props } = _props;
    const dividerLineCoords = {
        x: x + strokeWidth / 2,
        y: y + (dividerLineLocalY ? dividerLineLocalY : height / 2),
    };
    const { dividerLineLocalY: interactionRectDividerLineLocalY, showSectionLabels: interactionRectShowSectionLabels, dividerLineRef: interactionRectDividerLineRef, isCollapsed: interactionRectIsCollapsed, isReadOnly: interactionRectIsReadonly, ...interactionRectProps } = _interactionRectProps;
    return (_jsxs(_Fragment, { children: [!isCollapsed && (_jsxs(_Fragment, { children: [!isReadOnly && (_jsx("path", { ref: dividerLineRef, className: `kie-dmn-editor--node-decisionService-interactionDividerLine`, d: `M0,0 L${width},0`, strokeWidth: DEFAULT_INTRACTION_WIDTH / 2, style: { stroke: "transparent !important" }, transform: `translate(${dividerLineCoords.x},${dividerLineCoords.y})` })), _jsx("path", { d: `M0,0 L${width},0`, strokeLinejoin: "round", strokeWidth: strokeWidth, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, transform: `translate(${dividerLineCoords.x},${dividerLineCoords.y})` })] })), _jsx("rect", { ...props, x: x, y: y, width: width, height: height, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", rx: "40", ry: "40", className: "kie-dmn-editor--node-decisionService-visibleRect" }), _jsx("rect", { ...interactionRectProps, ref: ref, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, strokeWidth: interactionRectStrokeWidth, fill: "transparent", stroke: "transparent", strokeLinejoin: "round", rx: "30", ry: "30", className: containerNodeInteractionRectCssClassName }), showSectionLabels && !isCollapsed && (_jsxs(_Fragment, { children: [_jsx("text", { className: "kie-dmn-editor--decision-service-label", textAnchor: "middle", dominantBaseline: "auto", transform: `translate(${dividerLineCoords.x + width / 2},${dividerLineCoords.y - 6})`, children: "OUTPUT" }), _jsx("text", { className: "kie-dmn-editor--decision-service-label", textAnchor: "middle", dominantBaseline: "hanging", transform: `translate(${dividerLineCoords.x + width / 2},${dividerLineCoords.y + 6})`, children: "ENCAPSULATED" })] }))] }));
});
export function TextAnnotationNodeSvg(__props) {
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props: _props } = normalize(__props);
    const { showPlaceholder, ...props } = _props;
    return (_jsxs(_Fragment, { children: [_jsx("rect", { x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: "transparent", strokeLinejoin: "round", transform: `translate(${x},${y})` }), _jsx("path", { ...props, x: x, y: y, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", d: `M20,0 L0,0 M0,0 L0,${height} M0,${height} L20,${height}`, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeWidth: strokeWidth, strokeLinejoin: "round", transform: `translate(${x},${y})` }), showPlaceholder && (_jsx("text", { x: "20%", y: "62.5%", style: { fontSize: "5em", fontWeight: "bold" }, children: "Text" }))] }));
}
export const GroupNodeSvg = React.forwardRef((__props, ref) => {
    var _a;
    const { strokeWidth, x, y, width, height, fillColor, strokeColor, props } = normalize(__props);
    const { strokeWidth: interactionRectStrokeWidth, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, props: _interactionRectProps, } = normalize({ ...__props, strokeWidth: DEFAULT_INTRACTION_WIDTH / 2 });
    const { strokeDasharray: interactionRectStrokeDasharray, ...interactionRectProps } = _interactionRectProps;
    const strokeDasharray = (_a = props.strokeDasharray) !== null && _a !== void 0 ? _a : "14,10,3,10";
    return (_jsxs(_Fragment, { children: [_jsx("rect", { ...props, x: x, y: y, width: width, height: height, fill: fillColor !== null && fillColor !== void 0 ? fillColor : "transparent", stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, strokeLinejoin: "round", strokeWidth: strokeWidth, strokeDasharray: strokeDasharray, rx: 40, ry: 40 }), _jsx("rect", { ...interactionRectProps, ref: ref, x: interactionRectX, y: interactionRectY, width: interactionRectWidth, height: interactionRectHeight, strokeWidth: interactionRectStrokeWidth, fill: "transparent", stroke: "transparent", rx: "30", ry: "30", className: containerNodeInteractionRectCssClassName })] }));
});
export function UnknownNodeSvg(_props) {
    var _a;
    const { strokeWidth, x, y, width, height, props } = normalize(_props);
    const strokeDasharray = (_a = props.strokeDasharray) !== null && _a !== void 0 ? _a : "2,4";
    return (_jsx(_Fragment, { children: _jsx("rect", { ...props, x: x, y: y, width: width, height: height, fill: "transparent", stroke: "red", strokeLinejoin: "round", strokeWidth: strokeWidth, strokeDasharray: strokeDasharray }) }));
}
function NodeCollectionMarker({ strokeWidth, strokeColor, fillColor, x, y, width, height, anchor, }) {
    const xPosition = x + width / 2;
    const xSpacing = 7;
    const y1Position = anchor === "bottom" ? y + height - 4 : y + 4;
    const y2Position = anchor === "bottom" ? y + height - 18 : y + 18;
    return (_jsxs(_Fragment, { children: [_jsx("line", { x1: xPosition - xSpacing, x2: xPosition - xSpacing, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("line", { x1: xPosition, x2: xPosition, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("line", { x1: xPosition + xSpacing, x2: xPosition + xSpacing, y1: y1Position, y2: y2Position, strokeWidth: strokeWidth, fill: fillColor !== null && fillColor !== void 0 ? fillColor : DEFAULT_NODE_FILL, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR })] }));
}
function NodeHiddenRequirementMarker({ strokeWidth, strokeColor, x, y, width, height, anchor, }) {
    const dotRadius = 1;
    const xPosition = anchor === "middle" ? x + width / 2 : x + width / 4;
    const xSpacing = 7;
    const yPosition = anchor === "middle" ? y + height - 18 : y + height - 11;
    return (_jsxs(_Fragment, { children: [_jsx("circle", { r: dotRadius, cx: xPosition - xSpacing, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("circle", { r: dotRadius, cx: xPosition, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR }), _jsx("circle", { r: dotRadius, cx: xPosition + xSpacing, cy: yPosition, strokeWidth: strokeWidth, fill: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR, stroke: strokeColor !== null && strokeColor !== void 0 ? strokeColor : DEFAULT_NODE_STROKE_COLOR })] }));
}
//# sourceMappingURL=NodeSvgs.js.map