import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect, useRef, useState } from "react";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { useFocusableElement } from "../focus/useFocusableElement";
import { useDmnEditorStoreApi } from "../store/StoreContext";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
export const invalidInlineFeelNameStyle = {
    color: "red",
    textDecoration: "red dotted underline",
    textUnderlinePosition: "under",
};
export function InlineFeelNameInput({ id, onRenamed, isReadOnly, name, shouldCommitOnBlur, isPlain, allUniqueNames, validate, placeholder, onKeyDown, saveInvalidValue, enableAutoFocusing, ...inputProps }) {
    var _a;
    const _validate = (validate !== null && validate !== void 0 ? validate : (validate = DMN15_SPEC.namedElement.isValidName));
    const inputRef = useRef(null);
    const previouslyFocusedElement = useRef();
    useFocusableElement(inputRef, (enableAutoFocusing !== null && enableAutoFocusing !== void 0 ? enableAutoFocusing : true) ? id : undefined);
    const restoreFocus = useCallback(() => {
        setTimeout(() => {
            var _a, _b;
            if (document.activeElement === inputRef.current) {
                (_b = (_a = previouslyFocusedElement.current) === null || _a === void 0 ? void 0 : _a.focus) === null || _b === void 0 ? void 0 : _b.call(_a);
            }
        }, 0);
    }, []);
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const [isValid, setValid] = useState(_validate(id, name, allUniqueNames(dmnEditorStoreApi.getState())));
    const updateIsValidFlag = useCallback((name) => {
        const isValid = _validate(id, name, allUniqueNames(dmnEditorStoreApi.getState()));
        setValid(isValid);
        return isValid;
    }, [_validate, allUniqueNames, dmnEditorStoreApi, id]);
    useEffect(() => {
        updateIsValidFlag(name);
    }, [name, updateIsValidFlag]);
    useEffect(() => {
        inputRef.current.value = name;
    }, [name]);
    const { style: _style, disabled, defaultValue, ..._inputProps } = inputProps;
    const _placeholder = placeholder !== null && placeholder !== void 0 ? placeholder : "Enter a name...";
    return (_jsx("input", { spellCheck: "false", ref: inputRef, style: {
            ...(isPlain ? { border: 0, outline: "none", background: "transparent" } : {}),
            flexGrow: 1,
            display: "inline",
            width: "100%",
            ...(isValid ? {} : invalidInlineFeelNameStyle),
            ..._style,
        }, size: 2 + Math.max(0, (_a = _placeholder === null || _placeholder === void 0 ? void 0 : _placeholder.length) !== null && _a !== void 0 ? _a : 0, name.length), onInput: (e) => {
            var _a, _b;
            e.target.size = 2 + Math.max(0, (_a = _placeholder === null || _placeholder === void 0 ? void 0 : _placeholder.length) !== null && _a !== void 0 ? _a : 0, (_b = e.target.value.length) !== null && _b !== void 0 ? _b : 0);
        }, disabled: isReadOnly, placeholder: _placeholder, onChange: (e) => updateIsValidFlag(e.currentTarget.value), defaultValue: name, onFocus: (e) => {
            var _a;
            previouslyFocusedElement.current = (_a = document.activeElement) !== null && _a !== void 0 ? _a : undefined;
        }, onKeyDown: (e) => {
            onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e);
            if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
                e.stopPropagation();
            }
            if (e.key === "Enter") {
                e.preventDefault();
                const isValid = updateIsValidFlag(e.currentTarget.value);
                if (isValid || saveInvalidValue) {
                    onRenamed(e.currentTarget.value);
                }
            }
            else if (e.key === "Escape") {
                e.preventDefault();
                e.currentTarget.value = name;
                updateIsValidFlag(e.currentTarget.value);
                e.currentTarget.blur();
            }
        }, onBlur: (e) => {
            if ((isValid || saveInvalidValue) && shouldCommitOnBlur) {
                onRenamed(e.currentTarget.value);
            }
            else {
                e.currentTarget.value = name;
                updateIsValidFlag(e.currentTarget.value);
            }
            restoreFocus();
        }, ..._inputProps }, id));
}
//# sourceMappingURL=InlineFeelNameInput.js.map