import * as React from "react";
import { NodeType } from "../diagram/connections/graphStructure";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
export type NodeIcons = {
    isAlternativeInputDataShape: boolean;
    nodeType: typeof NODE_TYPES.inputData;
} | {
    isAlternativeInputDataShape?: boolean;
    nodeType: Exclude<NodeType, typeof NODE_TYPES.inputData>;
};
export declare function RoundSvg({ children, padding, height, viewBox, }: React.PropsWithChildren<{
    padding?: string;
    height?: number;
    viewBox?: number;
}>): JSX.Element;
export declare function NodeIcon({ isAlternativeInputDataShape, nodeType }: NodeIcons): typeof AlternativeInputDataIcon;
export declare function InputDataIcon(props: {
    padding?: string;
    height?: number;
}): JSX.Element;
export declare function AlternativeInputDataIcon(props: {
    padding?: string;
    height?: number;
    viewBox?: number;
    transform?: string;
}): JSX.Element;
export declare function DecisionIcon(): JSX.Element;
export declare function BkmIcon(): JSX.Element;
export declare function KnowledgeSourceIcon(): JSX.Element;
export declare function DecisionServiceIcon(): JSX.Element;
export declare function GroupIcon(): JSX.Element;
export declare function TextAnnotationIcon(): JSX.Element;
export declare function UnknownIcon(): JSX.Element;
//# sourceMappingURL=Icons.d.ts.map