import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { buildXmlHref, parseXmlHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { useCallback, useMemo } from "react";
import { DmnObjectListItem } from "../externalNodes/DmnObjectListItem";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { useDmnEditor } from "../DmnEditorContext";
import { useResolvedTypeRef } from "../dataTypes/useResolvedTypeRef";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { DragAndDrop, Draggable } from "../draggable/Draggable";
import { buildFeelQNameFromNamespace } from "../feel/buildFeelQName";
import { Alert, AlertVariant } from "@patternfly/react-core/dist/js/components/Alert/Alert";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { useRefactor } from "../refactor/RefactorConfirmationDialog";
export function DecisionServiceProperties({ decisionService, namespace, index, }) {
    var _a, _b, _c;
    const { setState } = useDmnEditorStoreApi();
    const settings = useSettings();
    const { externalModelsByNamespace } = useExternalModels();
    const thisDmn = useDmnEditorStore((s) => s.dmn);
    const allExternalDmns = Object.entries(externalModelsByNamespace !== null && externalModelsByNamespace !== void 0 ? externalModelsByNamespace : {}).reduce((acc, [namespace, externalModel]) => {
        if (!externalModel) {
            console.warn(`DMN EDITOR: Could not find model with namespace '${namespace}'. Ignoring.`);
            return acc;
        }
        if (externalModel.type === "dmn") {
            acc.push(externalModel);
        }
        return acc;
    }, new Array());
    const allDrgElementsByHref = useMemo(() => {
        var _a;
        const ret = new Map();
        const allDmns = [{ model: thisDmn.model }, ...allExternalDmns.values()];
        for (let i = 0; i < allDmns.length; i++) {
            const anyDmn = allDmns[i];
            const namespace = anyDmn.model.definitions["@_namespace"];
            const drgElements = (_a = anyDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : [];
            for (let i = 0; i < drgElements.length; i++) {
                const element = drgElements[i];
                if (element.__$$element === "decision" || element.__$$element === "inputData") {
                    ret.set(buildXmlHref({ namespace, id: element["@_id"] }), element);
                }
            }
        }
        return ret;
    }, [allExternalDmns, thisDmn]);
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const isReadOnly = settings.isReadOnly || (!!namespace && namespace !== thisDmnsNamespace);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const resolvedTypeRef = useResolvedTypeRef((_a = decisionService.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"], namespace);
    const identifierId = useMemo(() => decisionService["@_id"], [decisionService]);
    const oldName = useMemo(() => { var _a; return (_a = decisionService["@_label"]) !== null && _a !== void 0 ? _a : decisionService["@_name"]; }, [decisionService]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog, newName } = useRefactor({
        index,
        identifierId,
        oldName,
    });
    const currentName = useMemo(() => {
        return newName === "" ? oldName : newName;
    }, [newName, oldName]);
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx(FormGroup, { label: "Name", children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: decisionService["@_id"], name: currentName, isReadOnly: isReadOnly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: setNewIdentifierNameCandidate, allUniqueNames: useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []) }) }), _jsx(FormGroup, { label: "Data type", children: _jsx(TypeRefSelector, { heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, isDisabled: isReadOnly, onChange: (newTypeRef) => {
                        setState((state) => {
                            var _a;
                            const drgElement = state.dmn.model.definitions.drgElement[index];
                            (_a = drgElement.variable) !== null && _a !== void 0 ? _a : (drgElement.variable = { "@_id": generateUuid(), "@_name": decisionService["@_name"] });
                            drgElement.variable["@_typeRef"] = newTypeRef;
                        });
                    } }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadOnly, value: (_b = decisionService.description) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: (newDescription) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) }), _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: decisionService["@_id"] }) }), _jsx(FormGroup, { label: "Output decisions", "data-testid": "kie-tools--dmn-editor--decision-service-output-decisions", children: _jsx(DecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.outputDecision, allDrgElementsByHref: allDrgElementsByHref }) }), _jsx(FormGroup, { label: "Encapsulated decisions", "data-testid": "kie-tools--dmn-editor--decision-service-encapsulated-decisions", children: _jsx(DecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.encapsulatedDecision, allDrgElementsByHref: allDrgElementsByHref }) }), _jsx(Divider, {}), _jsx(FormGroup, { label: "Input decisions", "data-testid": "kie-tools--dmn-editor--decision-service-input-decisions", children: _jsx(DraggableDecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.inputDecision, allDrgElementsByHref: allDrgElementsByHref, onChange: (newInputDecisions) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].inputDecision =
                                newInputDecisions;
                        });
                    }, isDisabled: isReadOnly }) }), _jsx(FormGroup, { label: "Input data", "data-testid": "kie-tools--dmn-editor--decision-service-input-data", children: _jsx(DraggableDecisionServiceElementList, { decisionServiceNamespace: namespace, elements: decisionService.inputData, allDrgElementsByHref: allDrgElementsByHref, onChange: (newInputData) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].inputData =
                                newInputData;
                        });
                    }, isDisabled: isReadOnly }) }), _jsx(DecisionServiceEquivalentFunction, { decisionService: decisionService, decisionServiceNamespace: namespace, allDrgElementsByHref: allDrgElementsByHref }), _jsx(DocumentationLinksFormGroup, { isReadOnly: isReadOnly, values: (_c = decisionService.extensionElements) === null || _c === void 0 ? void 0 : _c["kie:attachment"], onChange: (newExtensionElements) => {
                    setState((state) => {
                        state.dmn.model.definitions.drgElement[index].extensionElements =
                            {
                                "kie:attachment": newExtensionElements,
                            };
                    });
                } })] }));
}
export function DecisionServiceElementList({ decisionServiceNamespace, elements, allDrgElementsByHref, }) {
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    return (_jsxs("ul", { children: [(elements !== null && elements !== void 0 ? elements : []).length <= 0 && (_jsx("li", { style: { paddingLeft: "32px" }, children: _jsx("small", { children: _jsx("i", { children: "(Empty)" }) }) })), (elements !== null && elements !== void 0 ? elements : []).map((e) => {
                var _a, _b;
                const localHref = parseXmlHref(e["@_href"]);
                const resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
                const potentialExternalHref = buildXmlHref({
                    namespace: resolvedNamespace,
                    id: localHref.id,
                });
                return (_jsx("li", { style: { paddingLeft: "32px" }, children: _jsx(DmnObjectListItem, { dmnObjectHref: potentialExternalHref, dmnObject: allDrgElementsByHref.get(potentialExternalHref), relativeToNamespace: thisDmnsNamespace, namespace: resolvedNamespace }) }, potentialExternalHref));
            })] }));
}
export function DraggableDecisionServiceElementList({ decisionServiceNamespace, elements, allDrgElementsByHref, onChange, isDisabled, }) {
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const [keys, setKeys] = React.useState(() => { var _a; return (_a = elements === null || elements === void 0 ? void 0 : elements.map((e) => e["@_href"])) !== null && _a !== void 0 ? _a : []; });
    const onDragEnd = useCallback((source, dest) => {
        const reordened = [...(elements !== null && elements !== void 0 ? elements : [])];
        const [removed] = reordened.splice(source, 1);
        reordened.splice(dest, 0, removed);
        onChange(reordened);
    }, [elements, onChange]);
    const reorder = useCallback((source, dest) => {
        setKeys((prev) => {
            const reordenedUuid = [...prev];
            const [removedUuid] = reordenedUuid.splice(source, 1);
            reordenedUuid.splice(dest, 0, removedUuid);
            return reordenedUuid;
        });
    }, []);
    const draggableItem = useCallback((element, index) => {
        var _a, _b;
        const localHref = parseXmlHref(element["@_href"]);
        const resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
        const potentialExternalHref = buildXmlHref({
            namespace: resolvedNamespace,
            id: localHref.id,
        });
        return (_jsx(Draggable, { index: index, handlerStyle: keys[index] ? { paddingLeft: "16px", paddingRight: "16px" } : { paddingLeft: "16px", paddingRight: "16px" }, isDisabled: isDisabled, children: _jsx("li", { children: _jsx(DmnObjectListItem, { dmnObjectHref: potentialExternalHref, dmnObject: allDrgElementsByHref.get(potentialExternalHref), relativeToNamespace: thisDmnsNamespace, namespace: resolvedNamespace }) }, potentialExternalHref) }, keys[index]));
    }, [allDrgElementsByHref, decisionServiceNamespace, isDisabled, keys, thisDmnsNamespace]);
    return (_jsxs("ul", { children: [(elements !== null && elements !== void 0 ? elements : []).length <= 0 && (_jsx("li", { style: { paddingLeft: "32px" }, children: _jsx("small", { children: _jsx("i", { children: "(Empty)" }) }) })), _jsx(DragAndDrop, { reorder: reorder, onDragEnd: onDragEnd, values: elements, draggableItem: draggableItem, isDisabled: isDisabled })] }));
}
function DecisionServiceEquivalentFunction({ decisionService, allDrgElementsByHref, decisionServiceNamespace, }) {
    const importsByNamespace = useDmnEditorStore((s) => s.computed(s).importsByNamespace());
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const getNodeNameByHref = useCallback((href) => {
        var _a, _b;
        const localHref = parseXmlHref(href);
        const resolvedNamespace = (_b = (_a = localHref.namespace) !== null && _a !== void 0 ? _a : decisionServiceNamespace) !== null && _b !== void 0 ? _b : thisDmnsNamespace;
        const potentialExternalHref = buildXmlHref({
            namespace: resolvedNamespace,
            id: localHref.id,
        });
        const dmnObject = allDrgElementsByHref.get(potentialExternalHref);
        const isNamespaceDirectlyIncluded = importsByNamespace.has(resolvedNamespace) || resolvedNamespace === thisDmnsNamespace;
        return dmnObject && isNamespaceDirectlyIncluded
            ? buildFeelQNameFromNamespace({
                namedElement: dmnObject,
                importsByNamespace,
                namespace: resolvedNamespace,
                relativeToNamespace: thisDmnsNamespace,
            }).full
            : buildDisplayNameForDmnObject(dmnObject, resolvedNamespace);
    }, [allDrgElementsByHref, decisionServiceNamespace, importsByNamespace, thisDmnsNamespace]);
    const buildFunctionArgList = useCallback((inputDecisions, inputData) => {
        const inputDecisionNodeNames = inputDecisions === null || inputDecisions === void 0 ? void 0 : inputDecisions.map((ide) => getNodeNameByHref(ide["@_href"]));
        const inputDataNodeNames = inputData === null || inputData === void 0 ? void 0 : inputData.map((ida) => getNodeNameByHref(ida["@_href"]));
        return [...(inputDecisionNodeNames !== null && inputDecisionNodeNames !== void 0 ? inputDecisionNodeNames : []), ...(inputDataNodeNames !== null && inputDataNodeNames !== void 0 ? inputDataNodeNames : [])].reduce((acc, name) => (acc ? `${acc}, ${name}` : name), "");
    }, [getNodeNameByHref]);
    return (_jsx(Alert, { variant: AlertVariant.info, isInline: true, title: "Invoking this Decision Service in FEEL", children: _jsx("p", { "data-testid": "kie-tools--dmn-editor--decision-service-feel", style: { fontFamily: "monospace" }, children: `${decisionService["@_name"]}(${buildFunctionArgList(decisionService.inputDecision, decisionService.inputData)})` }) }));
}
function buildDisplayNameForDmnObject(dmnObject, namespace) {
    return `${namespace.substring(0, 11)}...${namespace.substring(namespace.length - 4)}.${dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject["@_name"]}`;
}
//# sourceMappingURL=DecisionServiceProperties.js.map