import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useState } from "react";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { TypeRefSelector } from "../dataTypes/TypeRefSelector";
export function ContentField(props) {
    return _jsx(TextField, { ...props, type: TextFieldType.TEXT_AREA, title: "Content", placeholder: "Enter the content..." });
}
export function DescriptionField(props) {
    return (_jsx(TextField, { ...props, type: TextFieldType.TEXT_AREA, title: "Description", placeholder: "Enter a description..." }));
}
export function ExpressionLanguageField(props) {
    return (_jsx(TextField, { ...props, type: TextFieldType.TEXT_INPUT, title: "Expression Language", placeholder: "Enter the expression language..." }));
}
export function NameField(props) {
    return (_jsx(FormGroup, { label: props.alternativeFieldName ? props.alternativeFieldName : "Name", children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: props.id, name: props.name, isReadOnly: props.isReadOnly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: (newName) => { var _a; return (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, newName); }, allUniqueNames: props.getAllUniqueNames }) }));
}
export function TypeRefField(props) {
    return (_jsx(FormGroup, { label: props.alternativeFieldName ? props.alternativeFieldName : "Type", children: _jsx(TypeRefSelector, { heightRef: props.dmnEditorRootElementRef, typeRef: props.typeRef, isDisabled: props.isReadOnly, onChange: (newValue) => { var _a; return (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, newValue); } }) }));
}
export var TextFieldType;
(function (TextFieldType) {
    TextFieldType["TEXT_AREA"] = "text-area";
    TextFieldType["TEXT_INPUT"] = "text-input";
})(TextFieldType || (TextFieldType = {}));
export function TextField({ onChange, ...props }) {
    var _a, _b;
    const [expressionPath, setExpressionPath] = useState(props.expressionPath);
    const [value, setValue] = useState(props.initialValue);
    const valueRef = React.useRef(props.initialValue);
    const isEditing = React.useRef(false);
    useEffect(() => {
        if (isEditing.current === false) {
            setValue(props.initialValue);
            setExpressionPath(props.expressionPath);
            valueRef.current = props.initialValue;
        }
    }, [props.initialValue, props.expressionPath]);
    useEffect(() => {
        return () => {
            if (isEditing.current === true) {
                if (props.initialValue === valueRef.current) {
                    return;
                }
                onChange === null || onChange === void 0 ? void 0 : onChange(valueRef.current, expressionPath);
                isEditing.current = false;
            }
        };
    }, [expressionPath, onChange, props.initialValue]);
    return (_jsxs(FormGroup, { label: props.title, children: [props.type === TextFieldType.TEXT_AREA && (_jsx(TextArea, { "aria-label": "Content", type: "text", isDisabled: props.isReadOnly, value: value, onChange: (newContent) => {
                    setValue(newContent);
                    valueRef.current = newContent;
                    isEditing.current = true;
                }, onBlur: () => {
                    if (props.initialValue === value) {
                        return;
                    }
                    onChange === null || onChange === void 0 ? void 0 : onChange(value, expressionPath);
                    isEditing.current = false;
                }, placeholder: (_a = props.placeholder) !== null && _a !== void 0 ? _a : "Enter the expression content...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 })), props.type === TextFieldType.TEXT_INPUT && (_jsx(TextInput, { "aria-label": "Content", type: "text", isDisabled: props.isReadOnly, value: value, onChange: (newContent) => {
                    setValue(newContent);
                    valueRef.current = newContent;
                    isEditing.current = true;
                }, onBlur: () => {
                    if (props.initialValue === value) {
                        return;
                    }
                    onChange === null || onChange === void 0 ? void 0 : onChange(value, expressionPath);
                    isEditing.current = false;
                }, placeholder: (_b = props.placeholder) !== null && _b !== void 0 ? _b : "Enter the expression content...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }))] }));
}
//# sourceMappingURL=Fields.js.map