import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { ClipboardCopy } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { TextArea } from "@patternfly/react-core/dist/js/components/TextArea";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { DocumentationLinksFormGroup } from "./DocumentationLinksFormGroup";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { useCallback, useMemo } from "react";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { useRefactor } from "../refactor/RefactorConfirmationDialog";
export function KnowledgeSourceProperties({ knowledgeSource, namespace, index, }) {
    var _a, _b, _c;
    const { setState } = useDmnEditorStoreApi();
    const settings = useSettings();
    const thisDmnsNamespace = useDmnEditorStore((s) => s.dmn.model.definitions["@_namespace"]);
    const isReadOnly = settings.isReadOnly || (!!namespace && namespace !== thisDmnsNamespace);
    const identifierId = useMemo(() => knowledgeSource["@_id"], [knowledgeSource]);
    const oldName = useMemo(() => { var _a; return (_a = knowledgeSource["@_label"]) !== null && _a !== void 0 ? _a : knowledgeSource["@_name"]; }, [knowledgeSource]);
    const { setNewIdentifierNameCandidate, refactorConfirmationDialog, newName } = useRefactor({
        index,
        identifierId,
        oldName,
    });
    const currentName = useMemo(() => {
        return newName === "" ? oldName : newName;
    }, [newName, oldName]);
    return (_jsxs(_Fragment, { children: [refactorConfirmationDialog, _jsx(FormGroup, { label: "Name", children: _jsx(InlineFeelNameInput, { enableAutoFocusing: false, isPlain: false, id: knowledgeSource["@_id"], name: currentName, isReadOnly: isReadOnly, shouldCommitOnBlur: true, className: "pf-c-form-control", onRenamed: setNewIdentifierNameCandidate, allUniqueNames: useCallback((s) => s.computed(s).getAllFeelVariableUniqueNames(), []) }) }), _jsx(FormGroup, { label: "Description", children: _jsx(TextArea, { "aria-label": "Description", type: "text", isDisabled: isReadOnly, value: (_a = knowledgeSource.description) === null || _a === void 0 ? void 0 : _a.__$$text, onChange: (newDescription) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].description = {
                                __$$text: newDescription,
                            };
                        });
                    }, placeholder: "Enter a description...", style: { resize: "vertical", minHeight: "40px" }, rows: 6 }) }), _jsx(FormGroup, { label: "ID", children: _jsx(ClipboardCopy, { isReadOnly: true, hoverTip: "Copy", clickTip: "Copied", children: knowledgeSource["@_id"] }) }), _jsx(FormGroup, { label: "Source type", children: _jsx(TextInput, { "aria-label": "Source type", type: "text", isDisabled: isReadOnly, value: (_b = knowledgeSource.type) === null || _b === void 0 ? void 0 : _b.__$$text, onChange: (newType) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index].type = {
                                __$$text: newType,
                            };
                        });
                    }, placeholder: "Enter source type..." }) }), _jsx(FormGroup, { label: "Location URI", children: _jsx(TextInput, { "aria-label": "Location URI", type: "text", isDisabled: isReadOnly, value: knowledgeSource["@_locationURI"], onChange: (newLocationUri) => {
                        setState((state) => {
                            state.dmn.model.definitions.drgElement[index]["@_locationURI"] =
                                newLocationUri;
                        });
                    }, placeholder: "Enter location URI..." }) }), _jsx(DocumentationLinksFormGroup, { isReadOnly: isReadOnly, values: (_c = knowledgeSource.extensionElements) === null || _c === void 0 ? void 0 : _c["kie:attachment"], onChange: (newExtensionElements) => {
                    setState((state) => {
                        state.dmn.model.definitions.drgElement[index].extensionElements =
                            {
                                "kie:attachment": newExtensionElements,
                            };
                    });
                } })] }));
}
//# sourceMappingURL=KnowledgeSourceProperties.js.map