import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { getActionColumn, getColumn } from "../utils/ProcessDefinitionListUtils";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import ProcessDefinitionListToolbar from "../ProcessDefinitionListToolbar/ProcessDefinitionListToolbar";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { DataTable } from "@kie-tools/runtime-tools-components/dist/components/DataTable";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
const ProcessDefinitionList = ({ isEnvelopeConnectedToChannel, driver, singularProcessLabel, isTriggerCloudEventEnabled = false, ouiaId, ouiaSafe, }) => {
    const [processDefinitionList, setProcessDefinitionList] = useState([]);
    const [isLoading, setIsLoading] = useState(true);
    const [filterProcessNames, setFilterProcessNames] = useState([]);
    const [error, setError] = useState();
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsLoading(true);
            return;
        }
        init();
        return () => {
            setFilterProcessNames([]);
        };
    }, [isEnvelopeConnectedToChannel]);
    const init = async () => {
        try {
            const response = await driver.getProcessDefinitionsQuery();
            const pdFilter = await driver.getProcessDefinitionFilter();
            setFilterProcessNames(pdFilter);
            setProcessDefinitionList(response);
            setIsLoading(false);
        }
        catch (errorContent) {
            setError(errorContent);
        }
    };
    const columns = [
        getColumn("processName", `${singularProcessLabel} Name`),
        getColumn("endpoint", "Endpoint"),
        getActionColumn((processDefinition) => {
            driver.openProcessForm(processDefinition);
        }, singularProcessLabel),
    ];
    const applyFilter = async () => {
        await driver.setProcessDefinitionFilter(filterProcessNames);
    };
    const filterProcessDefinition = () => {
        if (filterProcessNames.length === 0) {
            return processDefinitionList;
        }
        return processDefinitionList.filter((pd) => filterProcessNames.includes(pd.processName));
    };
    const processDefinitionLoadingComponent = (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: `Loading ${singularProcessLabel.toLowerCase()} definitions...`, ouiaId: "forms-list-loading-process-definitions" }) }));
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "process-definition-list", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(ProcessDefinitionListToolbar, { filterProcessNames: filterProcessNames, setFilterProcessNames: setFilterProcessNames, applyFilter: applyFilter, singularProcessLabel: singularProcessLabel }), _jsx(Divider, {}), _jsx(DataTable, { data: filterProcessDefinition(), isLoading: isLoading, columns: columns, error: false, LoadingComponent: processDefinitionLoadingComponent })] }));
};
export default ProcessDefinitionList;
//# sourceMappingURL=ProcessDefinitionList.js.map