import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { EmbeddedTaskFormChannelApiImpl } from "./EmbeddedTaskFormChannelApiImpl";
import { init } from "../envelope";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
export const EmbeddedTaskForm = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback((envelopeServer, container) => {
        init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
            targetOrigin: props.targetOrigin,
        });
        return envelopeServer.envelopeApi.requests.taskForm__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, { userTask: props.userTask, user: props.user });
    }, [props.targetOrigin, props.user, props.userTask]);
    return (_jsx(EmbeddedTaskFormEnvelope, { ref: forwardedRef, apiImpl: new EmbeddedTaskFormChannelApiImpl(props.driver), origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedTaskFormEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedTaskForm.js.map