import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback } from "react";
import { TaskFormGatewayApiImpl } from "./TaskFormGatewayApi";
import TaskFormContext from "./TaskFormContext";
import { useKogitoAppContext } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
export const TaskFormContextProvider = ({ children, options }) => {
    const appContext = useKogitoAppContext();
    const transformEndpointBaseUrl = useCallback((url) => {
        return (options === null || options === void 0 ? void 0 : options.transformEndpointBaseUrl) && url ? options.transformEndpointBaseUrl(url) : url;
    }, [options]);
    return (_jsx(TaskFormContext.Provider, { value: new TaskFormGatewayApiImpl(() => appContext.getCurrentUser(), transformEndpointBaseUrl), children: children }));
};
export default TaskFormContextProvider;
//# sourceMappingURL=TaskFormContextProvider.js.map