export class TaskInboxGatewayApiImpl {
    constructor(queries, getCurrentUser) {
        this.onOpenTaskListeners = [];
        this.onUpdateTaskListStateListeners = [];
        this.queries = queries;
        this.getCurrentUser = getCurrentUser;
    }
    get taskInboxState() {
        return this._taskInboxState;
    }
    setInitialState(taskInboxState) {
        this._taskInboxState = taskInboxState;
        return Promise.resolve();
    }
    clearOpenTask() {
        this.activeTask = null;
        return Promise.resolve();
    }
    openTask(task) {
        this.activeTask = task;
        this.onOpenTaskListeners.forEach((listener) => listener.onOpen(task));
        return Promise.resolve();
    }
    applyFilter(filter) {
        this._taskInboxState.filters = filter;
        this.onUpdateTaskListStateListeners.forEach((listener) => listener.onUpdate(this._taskInboxState));
        return Promise.resolve();
    }
    applySorting(sortBy) {
        this._taskInboxState.sortBy = sortBy;
        this.onUpdateTaskListStateListeners.forEach((listener) => listener.onUpdate(this._taskInboxState));
        return Promise.resolve();
    }
    getTaskById(taskId) {
        if (this.activeTask && this.activeTask.id === taskId) {
            return Promise.resolve(this.activeTask);
        }
        return this.queries.getUserTaskById(taskId);
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getAllTasks(offset, limit, this._taskInboxState.filters, this._taskInboxState.sortBy)
                .then((value) => {
                this._taskInboxState.currentPage = { offset, limit };
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
    onOpenTaskListen(listener) {
        this.onOpenTaskListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onOpenTaskListeners.indexOf(listener);
            if (index > -1) {
                this.onOpenTaskListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    onUpdateTaskListState(listener) {
        this.onUpdateTaskListStateListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onUpdateTaskListStateListeners.indexOf(listener);
            if (index > -1) {
                this.onUpdateTaskListStateListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
}
//# sourceMappingURL=TaskInboxGatewayApi.js.map