import { HttpMethod } from "../../fetch/FetchConstants";
import { CreateResourceFetchArgs, ResourceFetch, ResourceFetchArgs, UniqueResourceFetchArgs } from "../../fetch/ResourceFetch";
import { ResourceDataSource, ResourceGroupDescriptor, ResourceMetadataEnforcer } from "../common";
import { IService as IKnativeService } from "@kubernetes-models/knative/serving.knative.dev/v1/Service";
export type KnativeServiceDescriptor = IKnativeService & ResourceMetadataEnforcer;
export type KnativeServiceGroupDescriptor = ResourceGroupDescriptor<KnativeServiceDescriptor>;
export interface Trigger {
    from: {
        kind: string;
        name: string;
        namespace: string;
    };
    fieldPath: string;
    pause: boolean;
}
export interface CreateKnativeServiceTemplateArgs {
    uri: string;
    workspaceName: string;
    resourceDataSource: ResourceDataSource.TEMPLATE;
}
export type CreateKnativeServiceArgs = CreateResourceFetchArgs & (CreateKnativeServiceTemplateArgs | {
    descriptor: KnativeServiceDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const KNATIVE_SERVICE_TEMPLATE: (args: CreateResourceFetchArgs & CreateKnativeServiceTemplateArgs) => KnativeServiceDescriptor;
export declare class CreateKnativeService extends ResourceFetch {
    protected args: CreateKnativeServiceArgs;
    constructor(args: CreateKnativeServiceArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
export declare class ListKnativeServices extends ResourceFetch {
    protected args: ResourceFetchArgs & {
        labelSelector?: string;
    };
    constructor(args: ResourceFetchArgs & {
        labelSelector?: string;
    });
    method(): HttpMethod;
    endpoint(): string;
}
export declare class DeleteKnativeService extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
export declare class GetKnativeService extends ResourceFetch {
    protected args: UniqueResourceFetchArgs;
    constructor(args: UniqueResourceFetchArgs);
    method(): HttpMethod;
    endpoint(): string;
}
//# sourceMappingURL=KnativeService.d.ts.map