import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { FormBase } from "./FormBase";
import { useForm } from "./FormHook";
import { formI18n } from "./i18n";
export function FormComponent(props) {
    const i18n = useMemo(() => { var _a, _b; return (_a = props.i18n) !== null && _a !== void 0 ? _a : formI18n.setLocale((_b = props.locale) !== null && _b !== void 0 ? _b : navigator.language).getCurrent(); }, [props.i18n, props.locale]);
    const { onValidate, onSubmit, formStatus, jsonSchemaBridge, errorBoundaryRef, setFormRef } = useForm({
        i18n,
        formError: props.formError,
        setFormError: props.setFormError,
        formInputs: props.formInputs,
        setFormInputs: props.setFormInputs,
        formSchema: props.formSchema,
        onSubmit: props.onSubmit,
        onValidate: props.onValidate,
        removeRequired: props.removeRequired,
        entryPath: props.entryPath,
        propertiesEntryPath: props.propertiesEntryPath,
        validator: props.validator,
        setFormRef: props.setFormRef,
    });
    return (_jsx(_Fragment, { children: _jsx(FormBase, { ...props, i18n: i18n, formStatus: formStatus, errorBoundaryRef: errorBoundaryRef, jsonSchemaBridge: jsonSchemaBridge, formModel: props.formInputs, onSubmit: onSubmit, onValidate: onValidate, setFormRef: setFormRef, children: props.children }) }));
}
//# sourceMappingURL=FormComponent.js.map