import * as React from "react";
import { ErrorBoundary } from "@kie-tools/dmn-runner/dist/ErrorBoundary";
import { FormStatus } from "./FormStatus";
import { FormJsonSchemaBridge } from "./uniforms/FormJsonSchemaBridge";
import { Validator } from "./Validator";
import { FormI18n } from "./i18n";
export interface FormHook<Input extends Record<string, any>, Schema extends Record<string, any>> {
    formError: boolean;
    setFormError: React.Dispatch<React.SetStateAction<boolean>>;
    formInputs: Input;
    setFormInputs: React.Dispatch<React.SetStateAction<Input>>;
    formSchema?: Schema;
    onSubmit?: (model: object) => void;
    onValidate?: (model: object, error: object) => void;
    entryPath?: string;
    propertiesEntryPath?: string;
    validator?: Validator;
    removeRequired?: boolean;
    i18n: FormI18n;
    setFormRef?: (formElement: HTMLFormElement | null) => void;
}
export declare function useForm<Input extends Record<string, any>, Schema extends Record<string, any>>({ formError, setFormError, formInputs, setFormInputs, formSchema, onSubmit, onValidate, entryPath, propertiesEntryPath, validator, removeRequired, i18n, setFormRef, }: FormHook<Input, Schema>): {
    onSubmit: (formInputs: any) => void;
    onValidate: (formInputs: any, error: any) => {
        details: object[];
    } | undefined;
    formStatus: FormStatus;
    jsonSchemaBridge: FormJsonSchemaBridge | undefined;
    errorBoundaryRef: React.RefObject<ErrorBoundary>;
    setFormRef: React.Dispatch<React.SetStateAction<HTMLFormElement | null>>;
};
//# sourceMappingURL=FormHook.d.ts.map