export interface FormSchema {
    name: string;
    schema: any;
}
export interface FormResources {
    styles: Record<string, string>;
    scripts: Record<string, string>;
}
export interface FormConfiguration {
    schema: string;
    resources: FormResources;
}
export interface FormAsset<FormThemeFileExt extends string> {
    name: string;
    fileName: string;
    content: string;
    fileExt: FormThemeFileExt;
    config: FormConfiguration;
}
export interface FormCodeGenerationError {
    error: Error;
    fileName: string;
}
export interface FormCodeGeneratorTheme<FormThemeFileExt extends string, CustomFormAsset = FormAsset<FormThemeFileExt>> {
    generate: (formSchema: FormSchema) => CustomFormAsset;
}
export interface FormCodeGeneration<FormThemeFileExt extends string, CustomFormAsset extends FormAsset<FormThemeFileExt>> {
    formAsset: CustomFormAsset | undefined;
    formError: FormCodeGenerationError | undefined;
}
//# sourceMappingURL=types.d.ts.map