import { MessageProperty } from "../message";
export class BrowserComponentBus {
    constructor() {
        this.messageListener = (e) => {
            this.listener(e.data);
        };
    }
    start() {
        window.addEventListener("message", this.messageListener, false);
    }
    send(componentId, message) {
        console.debug("[BrowserComponentBus] Sending Message");
        console.debug(message);
        message.properties.set(MessageProperty.COMPONENT_ID, componentId);
        window.parent.postMessage(message, window.location.href);
    }
    setListener(onMessage) {
        this.listener = onMessage;
    }
    destroy() {
        window.removeEventListener("message", this.messageListener, false);
    }
}
//# sourceMappingURL=BrowserComponentBus.js.map