import { Position } from "vscode-languageserver-types";
export type EditorLanguageServiceCommandTypes<T extends string = never> = T | "editor.ls.commands.OpenCompletionItems";
export type EditorLanguageServiceCommandArgs = {
    "editor.ls.commands.OpenCompletionItems": {
        newCursorPosition: Position;
    };
};
export type EditorLanguageServiceCommandIds<T extends string> = Record<T, string>;
export type EditorLanguageServiceCommandHandlers<T extends keyof A, A extends EditorLanguageServiceCommandArgs> = {
    [K in T]: (args: A[K]) => any;
};
export interface EditorLanguageServiceCommandExecution<T extends keyof A, A extends EditorLanguageServiceCommandArgs> {
    name: T;
    args: A[T];
}
//# sourceMappingURL=EditorLanguageServiceChannelApi.d.ts.map