"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNodeFormat = getNodeFormat;
var jsonc = require("jsonc-parser");
var yaml_language_server_parser_1 = require("yaml-language-server-parser");
var api_1 = require("../api");
function getNodeFormat(content, node) {
    var nodeContent = content.slice(node.offset, node.offset + node.length);
    if (jsonc.parseTree(nodeContent) !== undefined) {
        return api_1.FileLanguage.JSON;
    }
    var yamlAST = (0, yaml_language_server_parser_1.load)(nodeContent);
    if (node.type === "array" && node.parent && nodeContent.slice(0, 1) == "-") {
        return getNodeFormat(content, node.parent);
    }
    if (yamlAST && !yamlAST.errors.length) {
        return api_1.FileLanguage.YAML;
    }
    return;
}
//# sourceMappingURL=getNodeFormat.js.map