"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.matchNodeWithLocation = matchNodeWithLocation;
var findNodesAtLocation_1 = require("./findNodesAtLocation");
var nodeUpUntilType_1 = require("./nodeUpUntilType");
function matchNodeWithLocation(root, node, path) {
    if (!root || !node || !path || !path.length) {
        return false;
    }
    var nodesAtLocation = (0, findNodesAtLocation_1.findNodesAtLocation)({ root: root, path: path, includeUncompleteProps: true });
    var nodeToMatch = (0, nodeUpUntilType_1.nodeUpUntilType)(node, ["object", "property"]);
    var starSelector = path[path.length - 1] === "*";
    if (starSelector && node.type === "array" && node.children) {
        return matchNodeWithLocation(root, node, path.slice(0, -1));
    }
    return nodesAtLocation.some(function (currentNode) { return (starSelector && currentNode === nodeToMatch) || (!starSelector && currentNode === node); });
}
//# sourceMappingURL=matchNodeWithLocation.js.map