import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { createAndGetMainContainer, extractOpenFileExtension, extractOpenFilePath, iframeFullscreenContainer, openRepoInExternalEditorContainer, removeAllChildren, waitForElementToBeReady, } from "../../utils";
import * as ReactDOM from "react-dom";
import { Main } from "../common/Main";
import { SingleEditorApp } from "./SingleEditorApp";
import { useCallback } from "react";
import { KOGITO_IFRAME_CONTAINER_CLASS, KOGITO_TOOLBAR_CONTAINER_CLASS } from "../../constants";
import { fetchFile } from "../../github/api";
import { useGitHubApi } from "../common/GitHubContext";
import { useGlobals } from "../common/GlobalContext";
import { OpenInExternalEditorButton } from "../openRepoInExternalEditor/OpenInExternalEditorButton";
export async function renderSingleEditorReadonlyApp(args) {
    await waitForElementToBeReady("textarea[id='read-only-cursor-text-area']");
    if (!args.dependencies.singleView.githubTextEditorToReplaceElement()) {
        args.logger.log(`Doesn't look like the GitHub page is ready yet.`);
        return;
    }
    const openFileExtension = extractOpenFileExtension(window.location.href);
    const openFilePath = extractOpenFilePath(window.location.href);
    if (!openFileExtension) {
        args.logger.log(`Unable to determine file extension from URL`);
        return;
    }
    if (!args.editorEnvelopeLocator.hasMappingFor(openFilePath)) {
        args.logger.log(`No enhanced editor available for "${openFilePath}" format.`);
        return;
    }
    cleanup(args.id, args.dependencies);
    ReactDOM.render(_jsxs(Main, { id: args.id, editorEnvelopeLocator: args.editorEnvelopeLocator, logger: args.logger, dependencies: args.dependencies, githubAuthTokenCookieName: args.githubAuthTokenCookieName, extensionIconUrl: args.extensionIconUrl, resourceContentServiceFactory: args.resourceContentServiceFactory, externalEditorManager: args.externalEditorManager, children: [ReactDOM.createPortal(_jsx(OpenInExternalEditorButton, { className: args.className, pageType: args.pageType }), openRepoInExternalEditorContainer(args.id, args.container())), _jsx(SingleEditorViewApp, { fileInfo: args.fileInfo, openFileExtension: openFileExtension })] }), createAndGetMainContainer(args.id, args.dependencies.all.body()), () => args.logger.log("Mounted."));
}
function SingleEditorViewApp(props) {
    const githubApi = useGitHubApi();
    const globals = useGlobals();
    const getFileContents = useCallback(() => fetchFile(githubApi.octokit(), props.fileInfo.org, props.fileInfo.repo, props.fileInfo.gitRef, props.fileInfo.path), [githubApi, props.fileInfo.gitRef, props.fileInfo.org, props.fileInfo.path, props.fileInfo.repo]);
    const getFileName = useCallback(() => {
        return decodeURIComponent(props.fileInfo.path.split("/").pop());
    }, [props.fileInfo.path]);
    return (_jsx(SingleEditorApp, { readonly: true, openFileExtension: props.openFileExtension, getFileName: getFileName, getFileContents: getFileContents, iframeContainer: iframeContainer(globals.id, globals.dependencies), toolbarContainer: toolbarContainer(globals.id, globals.dependencies), githubTextEditorToReplace: globals.dependencies.singleView.githubTextEditorToReplaceElement(), fileInfo: props.fileInfo }));
}
function cleanup(id, dependencies) {
    removeAllChildren(iframeContainer(id, dependencies));
    removeAllChildren(toolbarContainer(id, dependencies));
    removeAllChildren(iframeFullscreenContainer(id, dependencies.all.body()));
    removeAllChildren(createAndGetMainContainer(id, dependencies.all.body()));
}
function toolbarContainer(id, dependencies) {
    var _a;
    const element = () => document.querySelector(`.${KOGITO_TOOLBAR_CONTAINER_CLASS}.${id}`);
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleView
        .toolbarContainerTarget()
        .insertAdjacentHTML("beforebegin", `<div class="${KOGITO_TOOLBAR_CONTAINER_CLASS} ${id} view d-flex flex-column flex-items-start flex-md-row"></div>`);
    return element();
}
export function iframeContainer(id, dependencies) {
    var _a;
    const element = () => document.querySelector(`.${KOGITO_IFRAME_CONTAINER_CLASS}.${id}`);
    if (element) {
        (_a = element()) === null || _a === void 0 ? void 0 : _a.remove();
    }
    dependencies.singleView
        .iframeContainerTarget()
        .insertAdjacentHTML("afterend", `<div class="${KOGITO_IFRAME_CONTAINER_CLASS} ${id} view"></div>`);
    return element();
}
//# sourceMappingURL=singleEditorView.js.map