"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseCamelRoutes = parseCamelRoutes;
exports.extractFunctions = extractFunctions;
var api_1 = require("../../../../api");
var convertSource_1 = require("../convertSource");
function parseCamelRoutes(args, serviceCamelRoutesDocument) {
    var swfServiceCatalogFunctions = extractFunctions(serviceCamelRoutesDocument, (0, convertSource_1.convertSource)(args.source));
    var serviceName = args.serviceFileName.split(".")[0];
    return {
        name: serviceName,
        type: api_1.SwfServiceCatalogServiceType.camelroute,
        source: args.source,
        functions: swfServiceCatalogFunctions,
        rawContent: args.serviceFileContent,
    };
}
function extractFunctions(serviceCamelRoutesDocument, source) {
    var swfServiceCatalogFunctions = serviceCamelRoutesDocument.map(function (routeItem) {
        return extractRouteItemFunctions(routeItem, source);
    });
    return [].concat.apply([], swfServiceCatalogFunctions);
}
function extractRouteItemFunctions(routeItem, source) {
    var _a;
    var swfServiceCatalogFunctions = [];
    var routeFrom;
    if ("from" in routeItem) {
        routeFrom = routeItem.from;
    }
    else if ("route" in routeItem) {
        routeFrom = (_a = routeItem.route) === null || _a === void 0 ? void 0 : _a.from;
    }
    var name = "camel:".concat(routeFrom === null || routeFrom === void 0 ? void 0 : routeFrom.uri);
    var functionArguments = {
        body: api_1.SwfServiceCatalogFunctionArgumentType.string,
        header: api_1.SwfServiceCatalogFunctionArgumentType.object,
    };
    var endpoint = routeFrom === null || routeFrom === void 0 ? void 0 : routeFrom.uri.split(":")[0];
    if (endpoint !== "direct") {
        console.log("'Only routes with direct endpoints are supported");
        return [];
    }
    var swfServiceCatalogFunction = {
        source: source,
        name: name,
        type: api_1.SwfServiceCatalogFunctionType.custom,
        arguments: functionArguments,
    };
    swfServiceCatalogFunctions.push(swfServiceCatalogFunction);
    return swfServiceCatalogFunctions;
}
//# sourceMappingURL=camelRoutes.js.map