"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvelopeBusMessageBroadcaster = void 0;
var EnvelopeBusMessageBroadcaster = (function () {
    function EnvelopeBusMessageBroadcaster() {
        this.subscriptions = [];
    }
    EnvelopeBusMessageBroadcaster.prototype.broadcast = function (message) {
        if (!message.targetEnvelopeServerId) {
            return;
        }
        this.subscriptions.forEach(function (callback) { return callback(message); });
    };
    EnvelopeBusMessageBroadcaster.prototype.subscribe = function (callback) {
        this.subscriptions.push(callback);
        return callback;
    };
    EnvelopeBusMessageBroadcaster.prototype.unsubscribe = function (callback) {
        var subscriptionIndex = this.subscriptions.indexOf(callback);
        if (subscriptionIndex >= 0) {
            this.subscriptions.splice(subscriptionIndex, 1);
        }
    };
    return EnvelopeBusMessageBroadcaster;
}());
exports.EnvelopeBusMessageBroadcaster = EnvelopeBusMessageBroadcaster;
//# sourceMappingURL=EnvelopeBusMessageBroadcaster.js.map