import * as vscode from "vscode";
import { TextDocument } from "vscode";
import { EditorApi, EditorEnvelopeLocator, EditorTheme, EnvelopeMapping, KogitoEditorChannelApi, KogitoEditorEnvelopeApi } from "@kie-tools-core/editor/dist/api";
import { VsCodeKieEditorStore } from "./VsCodeKieEditorStore";
import { EnvelopeBusMessageBroadcaster } from "./EnvelopeBusMessageBroadcaster";
import { EnvelopeServer } from "@kie-tools-core/envelope-bus/dist/channel";
import { VsCodeKieEditorCustomDocument } from "./VsCodeKieEditorCustomDocument";
export type KogitoEditorDocument = {
    type: "text";
    document: TextDocument;
} | {
    type: "custom";
    document: VsCodeKieEditorCustomDocument;
};
export declare class VsCodeKieEditorController implements EditorApi {
    readonly document: KogitoEditorDocument;
    readonly panel: vscode.WebviewPanel;
    private readonly context;
    private readonly editorStore;
    private readonly envelopeMapping;
    private readonly envelopeLocator;
    private readonly messageBroadcaster;
    readonly envelopeServer: EnvelopeServer<KogitoEditorChannelApi, KogitoEditorEnvelopeApi>;
    private broadcastSubscription;
    private changeDocumentSubscription;
    constructor(document: KogitoEditorDocument, panel: vscode.WebviewPanel, context: vscode.ExtensionContext, editorStore: VsCodeKieEditorStore, envelopeMapping: EnvelopeMapping, envelopeLocator: EditorEnvelopeLocator, messageBroadcaster: EnvelopeBusMessageBroadcaster, envelopeServer?: EnvelopeServer<KogitoEditorChannelApi, KogitoEditorEnvelopeApi>);
    private getEditorThemeByVscodeTheme;
    getCurrentTheme(): EditorTheme;
    getContent(): Promise<string>;
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    undo(): Promise<void>;
    redo(): Promise<void>;
    getPreview(): Promise<string>;
    validate(): Promise<import("@kie-tools-core/notifications/dist/api").Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    startInitPolling(apiImpl: KogitoEditorChannelApi): void;
    startListening(apiImpl: KogitoEditorChannelApi): void;
    setupPanelActiveStatusChange(): void;
    setupPanelOnDidDispose(): void;
    close(): void;
    hasUri(uri: vscode.Uri): boolean;
    isActive(): boolean;
    setupWebviewContent(): void;
    startListeningToThemeChanges(): void;
    stopListeningToDocumentChanges(): void;
    startListeningToDocumentChanges(): void;
    getDocumentContent(): Promise<string>;
}
//# sourceMappingURL=VsCodeKieEditorController.d.ts.map