import * as vscode from "vscode";
import { ResourceContentService } from "@kie-tools-core/workspace/dist/api";
import { EditorEnvelopeLocator } from "@kie-tools-core/editor/dist/api";
import { EnvelopeBusMessageBroadcaster } from "./EnvelopeBusMessageBroadcaster";
import { KogitoEditorDocument } from "./VsCodeKieEditorController";
import { VsCodeKieEditorStore } from "./VsCodeKieEditorStore";
import { I18n } from "@kie-tools-core/i18n/dist/core";
import { VsCodeI18n } from "./i18n";
import { JavaCodeCompletionApi } from "@kie-tools-core/vscode-java-code-completion/dist/api";
import { VsCodeKieEditorChannelApiProducer } from "./VsCodeKieEditorChannelApiProducer";
import { VsCodeNotificationsChannelApiImpl } from "./notifications/VsCodeNotificationsChannelApiImpl";
import { VsCodeWorkspaceChannelApiImpl } from "./workspace/VsCodeWorkspaceChannelApiImpl";
export declare class VsCodeKieEditorControllerFactory {
    private readonly context;
    private readonly editorStore;
    private readonly editorEnvelopeLocator;
    private readonly messageBroadcaster;
    private readonly vscodeWorkspace;
    private readonly vscodeNotifications;
    private readonly javaCodeCompletionApi;
    private readonly viewType;
    private readonly i18n;
    private readonly channelApiProducer;
    constructor(context: vscode.ExtensionContext, editorStore: VsCodeKieEditorStore, editorEnvelopeLocator: EditorEnvelopeLocator, messageBroadcaster: EnvelopeBusMessageBroadcaster, vscodeWorkspace: VsCodeWorkspaceChannelApiImpl, vscodeNotifications: VsCodeNotificationsChannelApiImpl, javaCodeCompletionApi: JavaCodeCompletionApi, viewType: string, i18n: I18n<VsCodeI18n>, channelApiProducer?: VsCodeKieEditorChannelApiProducer);
    configureNew(webviewPanel: vscode.WebviewPanel, document: KogitoEditorDocument): void;
    createResourceContentService(document: KogitoEditorDocument): ResourceContentService;
    private getChannelApi;
    private getEditorEnvelopeLocatorForWebview;
    private getWebViewPathFromEnvelopeContent;
    private getWebviewPath;
    private getParentFolder;
}
//# sourceMappingURL=VsCodeKieEditorControllerFactory.d.ts.map