/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.server.recovery;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.EnumSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.server.recovery.FileSystemStateStore$;
import org.apache.livy.server.recovery.StateStore;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b\u0001B\u0001\u0003\u00015\u0011ACR5mKNK8\u000f^3n'R\fG/Z*u_J,'BA\u0002\u0005\u0003!\u0011XmY8wKJL(BA\u0003\u0007\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0001C\u0001\u0005Y&4\u0018P\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0011\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005)\u0019F/\u0019;f'R|'/\u001a\t\u0003'Qi\u0011AB\u0005\u0003+\u0019\u0011q\u0001T8hO&tw\r\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003!a\u0017N^=D_:4\u0007CA\n\u001a\u0013\tQbA\u0001\u0005MSZL8i\u001c8g\u0011!a\u0002A!A!\u0002\u0013i\u0012aD7pG.4\u0015\u000e\\3D_:$X\r\u001f;\u0011\u0007y\t3%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0019y\u0005\u000f^5p]B\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003MNT!\u0001\u000b\u0005\u0002\r!\fGm\\8q\u0013\tQSEA\u0006GS2,7i\u001c8uKb$\b\"\u0002\u0017\u0001\t\u0003i\u0013A\u0002\u001fj]&$h\bF\u0002/_A\u0002\"a\u0004\u0001\t\u000b]Y\u0003\u0019\u0001\r\t\u000bqY\u0003\u0019A\u000f\t\u000b1\u0002A\u0011\u0001\u001a\u0015\u00059\u001a\u0004\"B\f2\u0001\u0004A\u0002bB\u001b\u0001\u0005\u0004%IAN\u0001\u0006MN,&/[\u000b\u0002oA\u0011\u0001(P\u0007\u0002s)\u0011!hO\u0001\u0004]\u0016$(\"\u0001\u001f\u0002\t)\fg/Y\u0005\u0003}e\u00121!\u0016*J\u0011\u0019\u0001\u0005\u0001)A\u0005o\u00051am]+sS\u0002BqA\u0011\u0001C\u0002\u0013%1)A\u0006gS2,7i\u001c8uKb$X#A\u0012\t\r\u0015\u0003\u0001\u0015!\u0003$\u000311\u0017\u000e\\3D_:$X\r\u001f;!\u0011\u00159\u0005\u0001\"\u0011I\u0003\r\u0019X\r\u001e\u000b\u0004\u00132+\u0006C\u0001\u0010K\u0013\tYuD\u0001\u0003V]&$\b\"B'G\u0001\u0004q\u0015aA6fsB\u0011qJ\u0015\b\u0003=AK!!U\u0010\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#~AQA\u0016$A\u0002]\u000bQA^1mk\u0016\u0004\"\u0001W.\u000e\u0003eS!AW\u001e\u0002\t1\fgnZ\u0005\u00039f\u0013aa\u00142kK\u000e$\b\"\u00020\u0001\t\u0003z\u0016aA4fiV\u0011\u0001-\u001a\u000b\u0003CZ$\"A\u00198\u0011\u0007y\t3\r\u0005\u0002eK2\u0001A!\u00024^\u0005\u00049'!\u0001+\u0012\u0005!\\\u0007C\u0001\u0010j\u0013\tQwDA\u0004O_RD\u0017N\\4\u0011\u0005ya\u0017BA7 \u0005\r\te.\u001f\u0005\b_v\u000b\t\u0011q\u0001q\u0003))g/\u001b3f]\u000e,G%\r\t\u0004cR\u001cW\"\u0001:\u000b\u0005M|\u0012a\u0002:fM2,7\r^\u0005\u0003kJ\u0014\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006\u001bv\u0003\rA\u0014\u0005\u0006q\u0002!\t%_\u0001\fO\u0016$8\t[5mIJ,g\u000eF\u0002{\u0003\u001b\u0001Ba_A\u0004\u001d:\u0019A0a\u0001\u000f\u0007u\f\t!D\u0001\u007f\u0015\tyH\"\u0001\u0004=e>|GOP\u0005\u0002A%\u0019\u0011QA\u0010\u0002\u000fA\f7m[1hK&!\u0011\u0011BA\u0006\u0005\r\u0019V-\u001d\u0006\u0004\u0003\u000by\u0002\"B'x\u0001\u0004q\u0005bBA\t\u0001\u0011\u0005\u00131C\u0001\u0007e\u0016lwN^3\u0015\u0007%\u000b)\u0002\u0003\u0004N\u0003\u001f\u0001\rA\u0014\u0005\b\u00033\u0001A\u0011BA\u000e\u0003\u001d\t'm\u001d)bi\"$B!!\b\u0002$A\u0019A%a\b\n\u0007\u0005\u0005RE\u0001\u0003QCRD\u0007BB'\u0002\u0018\u0001\u0007a\n")
public class FileSystemStateStore
extends StateStore
implements Logging {
    private final URI org$apache$livy$server$recovery$FileSystemStateStore$$fsUri;
    private final FileContext org$apache$livy$server$recovery$FileSystemStateStore$$fileContext;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        FileSystemStateStore fileSystemStateStore = this;
        synchronized (fileSystemStateStore) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public URI org$apache$livy$server$recovery$FileSystemStateStore$$fsUri() {
        return this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri;
    }

    public FileContext org$apache$livy$server$recovery$FileSystemStateStore$$fileContext() {
        return this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext;
    }

    @Override
    public void set(String key, Object value) {
        Path tmpPath = this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE);
        Utils$.MODULE$.usingResource((Closeable)this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().create(tmpPath, createFlag, new Options.CreateOpts[]{Options.CreateOpts.createParent()}), (Function1)new Serializable(this, key, value, tmpPath){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileSystemStateStore $outer;
            private final String key$1;
            private final Object value$1;
            private final Path tmpPath$1;

            public final void apply(FSDataOutputStream tmpFile) {
                tmpFile.write(this.$outer.serializeToBytes(this.value$1));
                tmpFile.close();
                this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().rename(this.tmpPath$1, this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(this.key$1), new Options.Rename[]{Options.Rename.OVERWRITE});
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.key$1 = key$1;
                this.value$1 = value$1;
                this.tmpPath$1 = tmpPath$1;
            }
        });
        try {
            Path crcPath = new Path(tmpPath.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".crc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tmpPath.getName()})));
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().delete(crcPath, false);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public <T> Option<T> get(String key, ClassTag<T> evidence$1) {
        None$ none$;
        try {
            none$ = (Option)Utils$.MODULE$.usingResource((Closeable)this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().open(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key)), (Function1)new Serializable(this, evidence$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemStateStore $outer;
                private final ClassTag evidence$1$1;

                public final Option<T> apply(FSDataInputStream is) {
                    return Option$.MODULE$.apply(this.$outer.deserialize(IOUtils.toByteArray((InputStream)is), this.evidence$1$1));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.evidence$1$1 = evidence$1$1;
                }
            });
        }
        catch (IOException iOException) {
            this.warn((Function0<Object>)new Serializable(this, key, iOException){
                public static final long serialVersionUID = 0L;
                private final String key$2;
                private final IOException e$1;

                public final Tuple2<String, IOException> apply() {
                    return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read ", " from state store."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2})), (Object)this.e$1);
                }
                {
                    this.key$2 = key$2;
                    this.e$1 = e$1;
                }
            });
            none$ = None$.MODULE$;
        }
        catch (FileNotFoundException fileNotFoundException) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Seq<String> getChildren(String key) {
        Seq seq;
        try {
            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().util().listStatus(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$1) {
                    return x$1.getPath().getName();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (IOException iOException) {
            this.warn((Function0<Object>)new Serializable(this, key, iOException){
                public static final long serialVersionUID = 0L;
                private final String key$3;
                private final IOException e$2;

                public final Tuple2<String, IOException> apply() {
                    return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to list ", " from state store."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$3})), (Object)this.e$2);
                }
                {
                    this.key$3 = key$3;
                    this.e$2 = e$2;
                }
            });
            seq = (Seq)Seq$.MODULE$.empty();
        }
        catch (FileNotFoundException fileNotFoundException) {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    @Override
    public void remove(String key) {
        this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().delete(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(key), false);
    }

    public Path org$apache$livy$server$recovery$FileSystemStateStore$$absPath(String key) {
        return new Path(this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri().getPath(), key);
    }

    public FileSystemStateStore(LivyConf livyConf, Option<FileContext> mockFileContext) {
        Path stateStorePath;
        block4: {
            super(livyConf);
            Logging.class.$init$((Logging)this);
            String fsPath = livyConf.get(LivyConf$.MODULE$.RECOVERY_STATE_STORE_URL());
            Predef$.MODULE$.require(!fsPath.isEmpty(), (Function0)new $anonfun$1(this));
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri = new URI(fsPath);
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext = (FileContext)mockFileContext.getOrElse((Function0)new $anonfun$2(this));
            this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().setUMask(new FsPermission("077"));
            stateStorePath = this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath(".");
            try {
                this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().mkdir(stateStorePath, FsPermission.getDirDefault(), true);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (!this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().getFileStatus(stateStorePath).isDirectory()) break block4;
            }
            FileStatus fileStatus = this.org$apache$livy$server$recovery$FileSystemStateStore$$fileContext().getFileStatus(this.org$apache$livy$server$recovery$FileSystemStateStore$$absPath("."));
            FsAction fsAction = fileStatus.getPermission().getUserAction();
            FsAction fsAction2 = FsAction.ALL;
            Predef$.MODULE$.require(!(fsAction != null ? !fsAction.equals(fsAction2) : fsAction2 != null), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemStateStore $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Livy doesn't have permission to access state store: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            FsAction fsAction3 = fileStatus.getPermission().getGroupAction();
            FsAction fsAction4 = FsAction.NONE;
            if (fsAction3 == null ? fsAction4 != null : !fsAction3.equals(fsAction4)) {
                this.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystemStateStore $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Group users have permission to access state store: ", ". This is insecure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            FsAction fsAction5 = fileStatus.getPermission().getOtherAction();
            FsAction fsAction6 = FsAction.NONE;
            if (fsAction5 == null ? fsAction6 != null : !fsAction5.equals(fsAction6)) {
                this.warn((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ FileSystemStateStore $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Other users have permission to access state store: ", ". This is in secure."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$server$recovery$FileSystemStateStore$$fsUri()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return;
        }
        throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{stateStorePath})));
    }

    public FileSystemStateStore(LivyConf livyConf) {
        this(livyConf, (Option<FileContext>)None$.MODULE$);
    }
}

