/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Promise;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.client.common.TestUtils;
import org.apache.livy.rsc.BaseProtocol;
import org.apache.livy.rsc.ContextInfo;
import org.apache.livy.rsc.DriverProcessInfo;
import org.apache.livy.rsc.FutureListener;
import org.apache.livy.rsc.RSCClientFactory;
import org.apache.livy.rsc.RSCConf;
import org.apache.livy.rsc.Utils;
import org.apache.livy.rsc.driver.RSCDriverBootstrapper;
import org.apache.livy.rsc.rpc.Rpc;
import org.apache.livy.rsc.rpc.RpcDispatcher;
import org.apache.livy.rsc.rpc.RpcServer;
import org.apache.spark.launcher.SparkLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(ContextLauncher.class);
    private static final AtomicInteger CHILD_IDS = new AtomicInteger();
    private static final String SPARK_DEPLOY_MODE = "spark.submit.deployMode";
    private static final String SPARK_JARS_KEY = "spark.jars";
    private static final String SPARK_ARCHIVES_KEY = "spark.yarn.dist.archives";
    private static final String SPARK_HOME_ENV = "SPARK_HOME";
    private final Promise<ContextInfo> promise;
    private final ScheduledFuture<?> timeout;
    private final String clientId;
    private final String secret;
    private final ChildProcess child;
    private final RSCConf conf;
    private final RSCClientFactory factory;
    static Process mockSparkSubmit;

    static DriverProcessInfo create(RSCClientFactory factory, RSCConf conf) throws IOException {
        ContextLauncher launcher = new ContextLauncher(factory, conf);
        return new DriverProcessInfo(launcher.promise, launcher.child.child);
    }

    private ContextLauncher(RSCClientFactory factory, RSCConf conf) throws IOException {
        this.promise = factory.getServer().getEventLoopGroup().next().newPromise();
        this.clientId = UUID.randomUUID().toString();
        this.secret = factory.getServer().createSecret();
        this.conf = conf;
        this.factory = factory;
        final RegistrationHandler handler = new RegistrationHandler();
        try {
            factory.getServer().registerClient(this.clientId, this.secret, handler);
            String replMode = conf.get("repl");
            boolean repl = replMode != null && replMode.equals("true");
            conf.set(RSCConf.Entry.LAUNCHER_ADDRESS, (Object)factory.getServer().getAddress());
            conf.set(RSCConf.Entry.LAUNCHER_PORT, factory.getServer().getPort());
            conf.set(RSCConf.Entry.CLIENT_ID, (Object)this.clientId);
            conf.set(RSCConf.Entry.CLIENT_SECRET, (Object)this.secret);
            Utils.addListener(this.promise, new FutureListener<ContextInfo>(){

                @Override
                public void onFailure(Throwable error) throws Exception {
                    if (ContextLauncher.this.child != null) {
                        ContextLauncher.this.child.kill();
                    }
                }
            });
            this.child = ContextLauncher.startDriver(conf, this.promise);
            Runnable timeoutTask = new Runnable(){

                @Override
                public void run() {
                    ContextLauncher.this.connectTimeout(handler);
                }
            };
            this.timeout = factory.getServer().getEventLoopGroup().schedule(timeoutTask, conf.getTimeAsMs(RSCConf.Entry.RPC_CLIENT_HANDSHAKE_TIMEOUT), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.dispose(true);
            throw Utils.propagate(e);
        }
    }

    private void connectTimeout(RegistrationHandler handler) {
        if (this.promise.tryFailure((Throwable)new TimeoutException("Timed out waiting for context to start."))) {
            handler.dispose();
        }
        this.dispose(true);
    }

    private void dispose(boolean forceKill) {
        this.factory.getServer().unregisterClient(this.clientId);
        try {
            if (this.child != null) {
                if (forceKill) {
                    this.child.kill();
                } else {
                    this.child.detach();
                }
            }
        }
        finally {
            this.factory.unref();
        }
    }

    private static ChildProcess startDriver(RSCConf conf, Promise<?> promise) throws IOException {
        String jacocoArgs;
        String livyJars = conf.get(RSCConf.Entry.LIVY_JARS);
        if (livyJars == null) {
            String livyHome = System.getenv("LIVY_HOME");
            Utils.checkState(livyHome != null, "Need one of LIVY_HOME or %s set.", RSCConf.Entry.LIVY_JARS.key());
            File rscJars = new File(livyHome, "rsc-jars");
            if (!rscJars.isDirectory()) {
                rscJars = new File(livyHome, "rsc/target/jars");
            }
            Utils.checkState(rscJars.isDirectory(), "Cannot find 'client-jars' directory under LIVY_HOME.", new Object[0]);
            ArrayList<String> jars = new ArrayList<String>();
            for (File f : rscJars.listFiles()) {
                jars.add(f.getAbsolutePath());
            }
            livyJars = Utils.join(jars, ",");
        }
        ContextLauncher.merge(conf, SPARK_JARS_KEY, livyJars, ",");
        ContextLauncher.merge(conf, SPARK_ARCHIVES_KEY, conf.get(RSCConf.Entry.SPARKR_PACKAGE), ",");
        ContextLauncher.merge(conf, "spark.submit.pyFiles", conf.get(RSCConf.Entry.PYSPARK_ARCHIVES), ",");
        conf.set("spark.yarn.maxAppAttempts", "1");
        conf.set("spark.yarn.submit.waitAppCompletion", "false");
        if (!conf.getBoolean(RSCConf.Entry.CLIENT_IN_PROCESS) && !conf.getBoolean(RSCConf.Entry.TEST_STUCK_END_SESSION) && (jacocoArgs = TestUtils.getJacocoArgs()) != null) {
            ContextLauncher.merge(conf, "spark.driver.extraJavaOptions", jacocoArgs, " ");
        }
        final File confFile = ContextLauncher.writeConfToFile(conf);
        if (mockSparkSubmit != null) {
            LOG.warn("!!!! Using mock spark-submit. !!!!");
            return new ChildProcess(conf, promise, mockSparkSubmit, confFile);
        }
        if (conf.getBoolean(RSCConf.Entry.CLIENT_IN_PROCESS)) {
            LOG.warn("!!!! Running remote driver in-process. !!!!");
            Runnable child = new Runnable(){

                @Override
                public void run() {
                    try {
                        RSCDriverBootstrapper.main(new String[]{confFile.getAbsolutePath()});
                    }
                    catch (Exception e) {
                        throw Utils.propagate(e);
                    }
                }
            };
            return new ChildProcess(conf, promise, child, confFile);
        }
        SparkLauncher launcher = new SparkLauncher();
        String deployMode = conf.get(SPARK_DEPLOY_MODE);
        if (deployMode != null) {
            launcher.setDeployMode(deployMode);
        }
        launcher.setSparkHome(System.getenv(SPARK_HOME_ENV));
        launcher.setAppResource("spark-internal");
        launcher.setPropertiesFile(confFile.getAbsolutePath());
        launcher.setMainClass(RSCDriverBootstrapper.class.getName());
        if (conf.get(RSCConf.Entry.PROXY_USER) != null) {
            launcher.addSparkArg("--proxy-user", conf.get(RSCConf.Entry.PROXY_USER));
        }
        return new ChildProcess(conf, promise, launcher.launch(), confFile);
    }

    private static void merge(RSCConf conf, String key, String livyConf, String sep) {
        String confValue = Utils.join(Arrays.asList(livyConf, conf.get(key)), sep);
        conf.set(key, confValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File writeConfToFile(RSCConf conf) throws IOException {
        File sparkDefaults;
        Properties confView = new Properties();
        for (Map.Entry<String, String> e : conf) {
            String key = e.getKey();
            if (!key.startsWith("spark.")) {
                key = "spark.__livy__." + key;
            }
            confView.setProperty(key, e.getValue());
        }
        String confDir = System.getenv("SPARK_CONF_DIR");
        if (confDir == null && System.getenv(SPARK_HOME_ENV) != null) {
            confDir = System.getenv(SPARK_HOME_ENV) + File.separator + "conf";
        }
        if (confDir != null && (sparkDefaults = new File(confDir + File.separator + "spark-defaults.conf")).isFile()) {
            Properties sparkConf = new Properties();
            try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(sparkDefaults), StandardCharsets.UTF_8);){
                sparkConf.load(r);
            }
            for (String key : sparkConf.stringPropertyNames()) {
                if (confView.containsKey(key)) continue;
                confView.put(key, sparkConf.getProperty(key));
            }
        }
        File file = File.createTempFile("livyConf", ".properties");
        Files.setPosixFilePermissions(file.toPath(), EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            confView.store(writer, "Livy App Context Configuration");
        }
        return file;
    }

    private static class ChildProcess {
        private final RSCConf conf;
        private final Promise<?> promise;
        private final Process child;
        private final Thread monitor;
        private final File confFile;

        public ChildProcess(RSCConf conf, Promise<?> promise, Runnable child, File confFile) {
            this.conf = conf;
            this.promise = promise;
            this.monitor = this.monitor(child, CHILD_IDS.incrementAndGet());
            this.child = null;
            this.confFile = confFile;
        }

        public ChildProcess(RSCConf conf, Promise<?> promise, Process childProc, File confFile) {
            int childId = CHILD_IDS.incrementAndGet();
            this.conf = conf;
            this.promise = promise;
            this.child = childProc;
            this.confFile = confFile;
            Runnable monitorTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        RSCClientFactory.childProcesses().incrementAndGet();
                        int exitCode = ChildProcess.this.child.waitFor();
                        if (exitCode != 0) {
                            LOG.warn("Child process exited with code {}.", (Object)exitCode);
                            ChildProcess.this.fail(new IOException(String.format("Child process exited with code %d.", exitCode)));
                        }
                    }
                    catch (InterruptedException ie) {
                        LOG.warn("Waiting thread interrupted, killing child process.");
                        Thread.interrupted();
                        ChildProcess.this.child.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn("Exception while waiting for child process.", (Throwable)e);
                    }
                    finally {
                        RSCClientFactory.childProcesses().decrementAndGet();
                    }
                }
            };
            this.monitor = this.monitor(monitorTask, childId);
        }

        private void fail(Throwable error) {
            this.promise.tryFailure(error);
        }

        public void kill() {
            if (this.child != null) {
                this.child.destroy();
            }
            this.monitor.interrupt();
            this.detach();
            if (!this.monitor.isAlive()) {
                return;
            }
            if (this.monitor.isAlive()) {
                LOG.warn("Timed out shutting down remote driver, interrupting...");
                this.monitor.interrupt();
            }
        }

        public void detach() {
            try {
                this.monitor.join(this.conf.getTimeAsMs(RSCConf.Entry.CLIENT_SHUTDOWN_TIMEOUT));
            }
            catch (InterruptedException ie) {
                LOG.debug("Interrupted before driver thread was finished.");
            }
        }

        private Thread monitor(final Runnable task, int childId) {
            Runnable wrappedTask = new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        ChildProcess.this.confFile.delete();
                    }
                }
            };
            Thread thread = new Thread(wrappedTask);
            thread.setDaemon(true);
            thread.setName("ContextLauncher-" + childId);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.warn("Child task threw exception.", e);
                    ChildProcess.this.fail(e);
                }
            });
            thread.start();
            return thread;
        }
    }

    private class RegistrationHandler
    extends BaseProtocol
    implements RpcServer.ClientCallback {
        volatile BaseProtocol.RemoteDriverAddress driverAddress;
        private Rpc client;

        private RegistrationHandler() {
        }

        @Override
        public RpcDispatcher onNewClient(Rpc client) {
            LOG.debug("New RPC client connected from {}.", (Object)client.getChannel());
            this.client = client;
            return this;
        }

        @Override
        public void onSaslComplete(Rpc client) {
        }

        void dispose() {
            if (this.client != null) {
                this.client.close();
            }
        }

        private void handle(ChannelHandlerContext ctx, BaseProtocol.RemoteDriverAddress msg) {
            ContextInfo info = new ContextInfo(msg.host, msg.port, ContextLauncher.this.clientId, ContextLauncher.this.secret);
            if (ContextLauncher.this.promise.trySuccess((Object)info)) {
                ContextLauncher.this.timeout.cancel(true);
                LOG.debug("Received driver info for client {}: {}/{}.", new Object[]{this.client.getChannel(), msg.host, msg.port});
            } else {
                LOG.warn("Connection established but promise is already finalized.");
            }
            ctx.executor().submit(new Runnable(){

                @Override
                public void run() {
                    RegistrationHandler.this.dispose();
                    ContextLauncher.this.dispose(false);
                }
            });
        }
    }
}

