/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StatementState {
    Waiting("waiting"),
    Running("running"),
    Available("available"),
    Cancelling("cancelling"),
    Cancelled("cancelled");

    private static final Logger LOG;
    private final String state;
    private static final Map<StatementState, List<StatementState>> PREDECESSORS;

    private StatementState(String text) {
        this.state = text;
    }

    @JsonValue
    public String toString() {
        return this.state;
    }

    public boolean isOneOf(StatementState ... states) {
        for (StatementState s : states) {
            if (s != this) continue;
            return true;
        }
        return false;
    }

    static void put(StatementState key, Map<StatementState, List<StatementState>> map, StatementState ... values) {
        map.put(key, Collections.unmodifiableList(Arrays.asList(values)));
    }

    static boolean isValid(StatementState from, StatementState to) {
        return PREDECESSORS.get((Object)to).contains((Object)from);
    }

    static void validate(StatementState from, StatementState to) {
        LOG.debug("{} -> {}", (Object)from, (Object)to);
        if (!StatementState.isValid(from, to)) {
            throw new IllegalStateException("Illegal Transition: " + (Object)((Object)from) + " -> " + (Object)((Object)to));
        }
    }

    static {
        LOG = LoggerFactory.getLogger(StatementState.class);
        EnumMap<StatementState, List<StatementState>> predecessors = new EnumMap<StatementState, List<StatementState>>(StatementState.class);
        StatementState.put(Waiting, predecessors, new StatementState[0]);
        StatementState.put(Running, predecessors, Waiting);
        StatementState.put(Available, predecessors, Running);
        StatementState.put(Cancelling, predecessors, Running);
        StatementState.put(Cancelled, predecessors, Waiting, Cancelling);
        PREDECESSORS = Collections.unmodifiableMap(predecessors);
    }
}

