/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.sessions;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.server.batch.BatchSession;
import org.apache.livy.server.recovery.SessionStore;
import org.apache.livy.sessions.FinishedSessionState;
import org.apache.livy.sessions.Session;
import org.apache.livy.sessions.SessionManager$;
import org.apache.livy.sessions.SessionState;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tmr!B\u0015+\u0011\u0003\u0019d!B\u001b+\u0011\u00031\u0004\"B\u001f\u0002\t\u0003q\u0004bB \u0002\u0005\u0004%\t\u0001\u0011\u0005\u0007\u0013\u0006\u0001\u000b\u0011B!\t\u000f)\u000b!\u0019!C\u0001\u0001\"11*\u0001Q\u0001\n\u0005Cq\u0001T\u0001\u0012\u0002\u0013\u0005QJ\u0002\u00036U\u0001Q\bBCA\u0001\u0011\t\u0015\r\u0011\"\u0005\u0002\u0004!Q\u00111\u0002\u0005\u0003\u0002\u0003\u0006I!!\u0002\t\u0015\u00055\u0001B!A!\u0002\u0013\ty\u0001\u0003\u0006\u0002 !\u0011\t\u0011)A\u0005\u0003CA!\"!\r\t\u0005\u0003\u0005\u000b\u0011BA\u001a\u0011)\t\t\u0005\u0003B\u0001B\u0003%\u00111\t\u0005\u000b\u00037B!1!Q\u0001\f\u0005u\u0003BB\u001f\t\t\u0003\tI\u0007C\u0004\u0002|!!\u0019\"! \t\u0013\u0005-\u0005B1Q\u0005\u0016\u00055\u0005\u0002CAQ\u0011\u0001\u0006i!a$\t\u0011-B!\u0019)C\u000b\u0003GC\u0001\"a/\tA\u00035\u0011Q\u0015\u0005\t\u0003{C\u0001\u0015!\u0004\u0002@\"A\u0011Q\u0019\u0005!\u0002\u001b\t9\r\u0003\u0005\u0002N\"\u0001\u000bQBAd\u0011!\ty\r\u0003Q\u0001\u000e\u0005E\u0007\u0002CAl\u0011\u0001\u0006i!!5\t\u000f\u0005e\u0007\u0002\"\u0001\u0002\\\"9\u0011Q\u001c\u0005\u0005\u0002\u0005}\u0007bBAs\u0011\u0011\u0005\u0011q\u001d\u0005\b\u0003KDA\u0011AAx\u0011\u001d\t)\u0010\u0003C\u0001\u00037Dq!a>\t\t\u0003\tI\u0010C\u0004\u0003\u0002!!\tAa\u0001\t\u000f\t\u0005\u0001\u0002\"\u0001\u0003\u0016!9!\u0011\u0004\u0005\u0005\u0002\tm\u0001b\u0002B\u000f\u0011\u0011\u0005!q\u0004\u0005\b\u0005KAA\u0011\u0002B\u0014\r\u0019\u0011I\u0003\u0003\u0003\u0003,!1QH\nC\u0001\u0005gAqA!\u000f'\t\u0003\u0012Y\"\u0001\bTKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005-b\u0013\u0001C:fgNLwN\\:\u000b\u00055r\u0013\u0001\u00027jmfT!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO\u000e\u0001\u0001C\u0001\u001b\u0002\u001b\u0005Q#AD*fgNLwN\\'b]\u0006<WM]\n\u0003\u0003]\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00014\u0003e\u0019ViU*J\u001f:{&+R\"P-\u0016\u0013\u0016lX'P\t\u0016{vJ\u0012$\u0016\u0003\u0005\u0003\"AQ$\u000e\u0003\rS!\u0001R#\u0002\t1\fgn\u001a\u0006\u0002\r\u0006!!.\u0019<b\u0013\tA5I\u0001\u0004TiJLgnZ\u0001\u001b'\u0016\u001b6+S(O?J+5i\u0014,F%f{Vj\u0014#F?>3e\tI\u0001\u001f'\u0016\u001b6+S(O?J+5i\u0014,F%f{Vj\u0014#F?J+5i\u0014,F%f\u000bqdU#T'&{ej\u0018*F\u0007>3VIU-`\u001b>#Ui\u0018*F\u0007>3VIU-!\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0019a\nX3\u0016\u0003=S#\u0001U*\u000f\u0005a\n\u0016B\u0001*:\u0003\u0011quN\\3,\u0003Q\u0003\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\u0013Ut7\r[3dW\u0016$'BA-:\u0003)\tgN\\8uCRLwN\\\u0005\u00037Z\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\t\u0015ivA1\u0001_\u0005\u0005\u0019\u0016CA0c!\tA\u0004-\u0003\u0002bs\t9aj\u001c;iS:<\u0007C\u0001\u001bd\u0013\t!'FA\u0004TKN\u001c\u0018n\u001c8\u0005\u000b\u0019<!\u0019A4\u0003\u0003I\u000b\"a\u00185\u0011\u0005%<hB\u00016v\u001d\tYGO\u0004\u0002mg:\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003aJ\na\u0001\u0010:p_Rt\u0014\"A\u0019\n\u0005=\u0002\u0014BA\u0017/\u0013\tYC&\u0003\u0002wU\u000591+Z:tS>t\u0017B\u0001=z\u0005A\u0011VmY8wKJLX*\u001a;bI\u0006$\u0018M\u0003\u0002wUU)10!\b\u0002\u001aM\u0019\u0001b\u000e?\u0011\u0005utX\"\u0001\u0017\n\u0005}d#a\u0002'pO\u001eLgnZ\u0001\tY&4\u0018pQ8oMV\u0011\u0011Q\u0001\t\u0004{\u0006\u001d\u0011bAA\u0005Y\tAA*\u001b<z\u0007>tg-A\u0005mSZL8i\u001c8gA\u0005y1/Z:tS>t'+Z2pm\u0016\u0014\u0018\u0010E\u00049\u0003#\t)\"a\u0007\n\u0007\u0005M\u0011HA\u0005Gk:\u001cG/[8ocA!\u0011qCA\r\u0019\u0001!QA\u001a\u0005C\u0002\u001d\u0004B!a\u0006\u0002\u001e\u0011)Q\f\u0003b\u0001=\u0006a1/Z:tS>t7\u000b^8sKB!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u0003:fG>4XM]=\u000b\u0007\u0005-B&\u0001\u0004tKJ4XM]\u0005\u0005\u0003_\t)C\u0001\u0007TKN\u001c\u0018n\u001c8Ti>\u0014X-A\u0006tKN\u001c\u0018n\u001c8UsB,\u0007\u0003BA\u001b\u0003{qA!a\u000e\u0002:A\u0011a.O\u0005\u0004\u0003wI\u0014A\u0002)sK\u0012,g-C\u0002I\u0003\u007fQ1!a\u000f:\u00031iwnY6TKN\u001c\u0018n\u001c8t!\u0015A\u0014QIA%\u0013\r\t9%\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005-\u0013QKA\u000e\u001d\u0011\ti%!\u0015\u000f\u00079\fy%C\u0001;\u0013\r\t\u0019&O\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9&!\u0017\u0003\u0007M+\u0017OC\u0002\u0002Te\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\ty&!\u001a\u0002\u00165\u0011\u0011\u0011\r\u0006\u0004\u0003GJ\u0014a\u0002:fM2,7\r^\u0005\u0005\u0003O\n\tG\u0001\u0005DY\u0006\u001c8\u000fV1h)1\tY'!\u001d\u0002t\u0005U\u0014qOA=)\u0011\ti'a\u001c\u0011\rQB\u00111DA\u000b\u0011\u001d\tY\u0006\u0005a\u0002\u0003;Bq!!\u0001\u0011\u0001\u0004\t)\u0001C\u0004\u0002\u000eA\u0001\r!a\u0004\t\u000f\u0005}\u0001\u00031\u0001\u0002\"!9\u0011\u0011\u0007\tA\u0002\u0005M\u0002\"CA!!A\u0005\t\u0019AA\"\u0003!)\u00070Z2vi>\u0014XCAA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAACs\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005%\u00151\u0011\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\f\u0011\"\u001b3D_VtG/\u001a:\u0016\u0005\u0005=\u0005\u0003BAI\u0003;k!!a%\u000b\t\u0005U\u0015qS\u0001\u0007CR|W.[2\u000b\t\u0005\u0015\u0015\u0011\u0014\u0006\u0004\u00037+\u0015\u0001B;uS2LA!a(\u0002\u0014\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\f!\"\u001b3D_VtG/\u001a:!+\t\t)\u000b\u0005\u0005\u0002(\u0006E\u0016QWA\u000e\u001b\t\tIK\u0003\u0003\u0002,\u00065\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_K\u0014AC2pY2,7\r^5p]&!\u00111WAU\u00055a\u0015N\\6fI\"\u000b7\u000f['baB\u0019\u0001(a.\n\u0007\u0005e\u0016HA\u0002J]R\f\u0011b]3tg&|gn\u001d\u0011\u0002\u001dM,7o]5p]N\u0014\u0015PT1nKB9\u0011qUAa\u0003\u0006m\u0011\u0002BAb\u0003S\u0013q\u0001S1tQ6\u000b\u0007/A\ntKN\u001c\u0018n\u001c8US6,w.\u001e;DQ\u0016\u001c7\u000eE\u00029\u0003\u0013L1!a3:\u0005\u001d\u0011un\u001c7fC:\f1d]3tg&|g\u000eV5nK>,Ho\u00115fG.\u001c6.\u001b9CkNL\u0018AD:fgNLwN\u001c+j[\u0016|W\u000f\u001e\t\u0004q\u0005M\u0017bAAks\t!Aj\u001c8h\u0003e\u0019Xm]:j_:\u001cF/\u0019;f%\u0016$\u0018-\u001b8fI&s7+Z2\u0002\r9,\u0007\u0010^%e)\t\t),\u0001\u0005sK\u001eL7\u000f^3s)\u0011\tY\"!9\t\u000f\u0005\rH\u00041\u0001\u0002\u001c\u000591/Z:tS>t\u0017aA4fiR!\u0011\u0011^Av!\u0015A\u0014QIA\u000e\u0011\u001d\ti/\ba\u0001\u0003k\u000b!!\u001b3\u0015\t\u0005%\u0018\u0011\u001f\u0005\b\u0003gt\u0002\u0019AA\u001a\u0003-\u0019Xm]:j_:t\u0015-\\3\u0002\tML'0Z\u0001\u0004C2dGCAA~!\u0019\tY%!@\u0002\u001c%!\u0011q`A-\u0005!IE/\u001a:bE2,\u0017A\u00023fY\u0016$X\r\u0006\u0003\u0003\u0006\tM\u0001#\u0002\u001d\u0002F\t\u001d\u0001CBAA\u0005\u0013\u0011i!\u0003\u0003\u0003\f\u0005\r%A\u0002$viV\u0014X\rE\u00029\u0005\u001fI1A!\u0005:\u0005\u0011)f.\u001b;\t\u000f\u00055\u0018\u00051\u0001\u00026R!!q\u0001B\f\u0011\u001d\t\u0019O\ta\u0001\u00037\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0005\u001b\tabY8mY\u0016\u001cGoR1sE\u0006<W\r\u0006\u0002\u0003\"A1\u0011\u0011\u0011B\u0005\u0005G\u0001b!a\u0013\u0002~\n5\u0011a\u0002:fG>4XM\u001d\u000b\u0003\u0003\u0013\u0012\u0001cR1sE\u0006<WmQ8mY\u0016\u001cGo\u001c:\u0014\u0007\u0019\u0012i\u0003E\u0002C\u0005_I1A!\rD\u0005\u0019!\u0006N]3bIR\u0011!Q\u0007\t\u0004\u0005o1S\"\u0001\u0005\u0002\u0007I,h\u000e")
public class SessionManager<S extends Session, R extends Session.RecoveryMetadata>
implements Logging {
    private final LivyConf livyConf;
    private final Function1<R, S> sessionRecovery;
    private final SessionStore sessionStore;
    private final String sessionType;
    private final ClassTag<R> evidence$1;
    private final AtomicInteger idCounter;
    private final LinkedHashMap<Object, S> sessions;
    private final HashMap<String, S> sessionsByName;
    private final boolean sessionTimeoutCheck;
    private final boolean sessionTimeoutCheckSkipBusy;
    private final long sessionTimeout;
    private final long sessionStateRetainedInSec;
    private Logger logger;
    private volatile boolean bitmap$0;

    public static <S extends Session, R extends Session.RecoveryMetadata> None$ $lessinit$greater$default$5() {
        return SessionManager$.MODULE$.$lessinit$greater$default$5();
    }

    public static String SESSION_RECOVERY_MODE_RECOVERY() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_RECOVERY();
    }

    public static String SESSION_RECOVERY_MODE_OFF() {
        return SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
    }

    public void trace(Function0<Object> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContext executor() {
        return ExecutionContext$.MODULE$.global();
    }

    public final AtomicInteger idCounter() {
        return this.idCounter;
    }

    public final LinkedHashMap<Object, S> sessions() {
        return this.sessions;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized int nextId() {
        void var1_1;
        int id = this.idCounter().getAndIncrement();
        this.sessionStore.saveNextSessionId(this.sessionType, this.idCounter().get());
        return (int)var1_1;
    }

    public S register(S session) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Registering new session ").append(session.id()).toString());
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            ((Session)session).name().foreach((Function1 & Serializable & scala.Serializable)sessionName -> {
                if ($this.sessionsByName.contains(sessionName)) {
                    String errMsg = new StringBuilder(37).append("Duplicate session name: ").append(session.name()).append(" for session ").append(session.id()).toString();
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
                    session.stop();
                    throw new IllegalArgumentException(errMsg);
                }
                return $this.sessionsByName.put(sessionName, session);
            });
            this.sessions().put((Object)BoxesRunTime.boxToInteger((int)((Session)session).id()), session);
            ((Session)session).start();
        }
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Registered new session ").append(session.id()).toString());
        return session;
    }

    public Option<S> get(int id) {
        return this.sessions().get((Object)BoxesRunTime.boxToInteger((int)id));
    }

    public Option<S> get(String sessionName) {
        return this.sessionsByName.get((Object)sessionName);
    }

    public int size() {
        return this.sessions().size();
    }

    public Iterable<S> all() {
        return this.sessions().values();
    }

    public Option<Future<BoxedUnit>> delete(int id) {
        return this.get(id).map((Function1 & Serializable & scala.Serializable)session -> this.delete(session));
    }

    public Future<BoxedUnit> delete(S session) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Deleting session ").append(session.id()).toString());
        return ((Session)session).stop().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SessionManager.$anonfun$delete$3(this, session, x0$1);
            return BoxedUnit.UNIT;
        }, this.executor());
    }

    public void shutdown() {
        block0: {
            boolean recoveryEnabled;
            String string = this.livyConf().get(LivyConf$.MODULE$.RECOVERY_MODE());
            String string2 = SessionManager$.MODULE$.SESSION_RECOVERY_MODE_OFF();
            boolean bl = (string == null ? string2 != null : !string.equals(string2)) ? true : (recoveryEnabled = false);
            if (recoveryEnabled) break block0;
            ((IterableLike)this.sessions().values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.stop(), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)future -> (Future)Await$.MODULE$.ready((Awaitable)future, (Duration)Duration$.MODULE$.Inf()));
        }
    }

    public Future<Iterable<BoxedUnit>> collectGarbage() {
        return Future$.MODULE$.sequence((TraversableOnce)((TraversableLike)this.all().filter((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)this.expired$1(session)))).map((Function1 & Serializable & scala.Serializable)s -> {
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Deleting ").append(s).append(" because it was inactive for more than ").append((double)$this.sessionTimeout / 1000000.0).append(" ms.").toString());
            return this.delete(s);
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom(), this.executor());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<S> recover() {
        void var2_2;
        this.idCounter().set(this.sessionStore.getNextSessionId(this.sessionType));
        Seq<Try<R>> sessionMetadata = this.sessionStore.getAllSessions(this.sessionType, this.evidence$1);
        Seq recoveredSessions = (Seq)((TraversableLike)sessionMetadata.flatMap((Function1 & Serializable & scala.Serializable)x$4 -> Option$.MODULE$.option2Iterable(x$4.toOption()), Seq$.MODULE$.canBuildFrom())).map(this.sessionRecovery, Seq$.MODULE$.canBuildFrom());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Recovered ").append(recoveredSessions.length()).append(" ").append($this.sessionType).append(" sessions.").append(" Next session id: ").append(this.idCounter()).toString());
        Seq recoveryFailure = (Seq)((TraversableLike)sessionMetadata.filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isFailure()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (Throwable)x$6.failed().get(), Seq$.MODULE$.canBuildFrom());
        recoveryFailure.foreach((Function1 & Serializable & scala.Serializable)ex -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> ex.getMessage(), ex.getCause());
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ void $anonfun$delete$3(SessionManager $this, Session session$2, BoxedUnit x0$1) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2 = x0$1;
        try {
            try {
                $this.sessionStore.remove($this.sessionType, session$2.id());
                SessionManager sessionManager = $this;
                synchronized (sessionManager) {
                    $this.sessions().remove((Object)BoxesRunTime.boxToInteger((int)session$2.id()));
                    session$2.name().foreach((Function1 & Serializable & scala.Serializable)key -> $this.sessionsByName.remove(key));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    $this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Exception was thrown during stop session:", e);
                    throw e;
                }
                throw throwable;
            }
        }
        finally {
            $this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Deleted session ").append(session$2.id()).toString());
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    private final boolean expired$1(Session session) {
        boolean bl;
        SessionState sessionState = session.state();
        if (sessionState instanceof FinishedSessionState) {
            FinishedSessionState finishedSessionState = (FinishedSessionState)sessionState;
            long currentTime = System.nanoTime();
            bl = currentTime - finishedSessionState.time() > this.sessionStateRetainedInSec;
        } else {
            boolean bl2;
            if (!this.sessionTimeoutCheck) {
                bl2 = false;
            } else {
                SessionState sessionState2 = session.state();
                SessionState.Busy$ busy$ = SessionState.Busy$.MODULE$;
                if (!(sessionState2 != null ? !sessionState2.equals(busy$) : busy$ != null) && this.sessionTimeoutCheckSkipBusy) {
                    bl2 = false;
                } else if (session instanceof BatchSession) {
                    bl2 = false;
                } else {
                    long currentTime = System.nanoTime();
                    long calculatedTimeout = this.sessionTimeout;
                    if (session.ttl().isDefined()) {
                        calculatedTimeout = ClientConf.getTimeAsMs((String)((String)session.ttl().get()));
                    }
                    calculatedTimeout = TimeUnit.MILLISECONDS.toNanos(calculatedTimeout);
                    bl2 = currentTime - session.lastActivity() > calculatedTimeout;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public SessionManager(LivyConf livyConf, Function1<R, S> sessionRecovery, SessionStore sessionStore, String sessionType, Option<Seq<S>> mockSessions, ClassTag<R> evidence$1) {
        this.livyConf = livyConf;
        this.sessionRecovery = sessionRecovery;
        this.sessionStore = sessionStore;
        this.sessionType = sessionType;
        this.evidence$1 = evidence$1;
        Logging.$init$((Logging)this);
        this.idCounter = new AtomicInteger(0);
        this.sessions = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.sessionsByName = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.sessionTimeoutCheck = livyConf.getBoolean(LivyConf$.MODULE$.SESSION_TIMEOUT_CHECK());
        this.sessionTimeoutCheckSkipBusy = livyConf.getBoolean(LivyConf$.MODULE$.SESSION_TIMEOUT_CHECK_SKIP_BUSY());
        this.sessionTimeout = livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_TIMEOUT());
        this.sessionStateRetainedInSec = TimeUnit.MILLISECONDS.toNanos(livyConf.getTimeAsMs(LivyConf$.MODULE$.SESSION_STATE_RETAIN_TIME()));
        ((IterableLike)mockSessions.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.recover())).foreach((Function1 & Serializable & scala.Serializable)session -> this.register(session));
        new GarbageCollector().start();
    }

    private class GarbageCollector
    extends Thread {
        @Override
        public void run() {
            while (true) {
                this.org$apache$livy$sessions$SessionManager$GarbageCollector$$$outer().collectGarbage();
                Thread.sleep(60000L);
            }
        }

        public /* synthetic */ SessionManager org$apache$livy$sessions$SessionManager$GarbageCollector$$$outer() {
            return SessionManager.this;
        }

        public GarbageCollector() {
            if (SessionManager.this == null) {
                throw null;
            }
            super("session gc thread");
            this.setDaemon(true);
        }
    }
}

