/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import java.util.Objects;

public class ListPageRangesOptions {
    private final BlobRange range;
    private BlobRequestConditions requestConditions;
    private Integer pageSize;

    public ListPageRangesOptions(BlobRange range) {
        Objects.requireNonNull(range);
        this.range = new BlobRange(range.getOffset(), range.getCount());
    }

    public BlobRange getRange() {
        return this.range;
    }

    public BlobRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public ListPageRangesOptions setRequestConditions(BlobRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public Integer getMaxResultsPerPage() {
        return this.pageSize;
    }

    public ListPageRangesOptions setMaxResultsPerPage(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }
}

