/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.PageToken;

public class EntitiesResult
extends BaseResult {
    private final List<PolarisBaseEntity> entities;
    private final Optional<PageToken> pageTokenOpt;

    public static EntitiesResult fromPage(Page<PolarisBaseEntity> page) {
        return new EntitiesResult(page.items, Optional.ofNullable(page.pageToken));
    }

    public EntitiesResult(@Nonnull BaseResult.ReturnStatus errorStatus, @Nullable String extraInformation) {
        super(errorStatus, extraInformation);
        this.entities = null;
        this.pageTokenOpt = Optional.empty();
    }

    public EntitiesResult(@Nonnull List<PolarisBaseEntity> entities) {
        this(entities, Optional.empty());
    }

    public EntitiesResult(@Nonnull List<PolarisBaseEntity> entities, @Nonnull Optional<PageToken> pageTokenOpt) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.entities = entities;
        this.pageTokenOpt = pageTokenOpt;
    }

    @JsonCreator
    private EntitiesResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") String extraInformation, @JsonProperty(value="entities") List<PolarisBaseEntity> entities, @JsonProperty(value="pageToken") Optional<PageToken> pageTokenOpt) {
        super(returnStatus, extraInformation);
        this.entities = entities;
        this.pageTokenOpt = pageTokenOpt;
    }

    public List<PolarisBaseEntity> getEntities() {
        return this.entities;
    }

    public Optional<PageToken> getPageToken() {
        return this.pageTokenOpt;
    }
}

