/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.pagination;

import java.util.List;
import java.util.Objects;
import org.apache.polaris.core.persistence.pagination.LimitPageToken;
import org.apache.polaris.core.persistence.pagination.Page;
import org.apache.polaris.core.persistence.pagination.ReadEverythingPageToken;

public abstract class PageToken {
    public static PageToken readEverything() {
        return PageToken.build(null, null);
    }

    public static PageToken fromString(String token) {
        return PageToken.build(token, null);
    }

    public static PageToken fromLimit(Integer pageSize) {
        return PageToken.build(null, pageSize);
    }

    public static PageToken build(String token, Integer pageSize) {
        if (token == null || token.isEmpty()) {
            if (pageSize != null) {
                return new LimitPageToken(pageSize);
            }
            return new ReadEverythingPageToken();
        }
        throw new IllegalArgumentException("Unrecognized page token: " + token);
    }

    public abstract String toTokenString();

    protected abstract PageToken updated(List<?> var1);

    public final <T> Page<T> buildNextPage(List<T> data) {
        return new Page<T>(this.updated(data), data);
    }

    public final boolean equals(Object o) {
        if (o instanceof PageToken) {
            return Objects.equals(this.toTokenString(), ((PageToken)o).toTokenString());
        }
        return false;
    }

    public final int hashCode() {
        if (this.toTokenString() == null) {
            return 0;
        }
        return this.toTokenString().hashCode();
    }
}

