/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.security.ProtectionDomain;
import org.jboss.classfilewriter.ClassFactory;
import org.jboss.classfilewriter.ClassFile;

public abstract class AbstractClassFactory<T> {
    private final String className;
    private final Class<T> superClass;
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;
    private volatile Class<? extends T> generatedClass;
    protected ClassFile classFile;
    private volatile boolean classGenerated;

    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader, ClassFactory classFactory, ProtectionDomain protectionDomain) {
        if (classLoader == null) {
            throw new IllegalArgumentException("ClassLoader cannot be null when attempting to proxy " + superClass + ". If you are trying to proxy a JDK class you must specify the class loader explicitly to prevent memory leaks");
        }
        if (superClass == null) {
            throw new IllegalArgumentException("Superclass cannot be null for proxy " + className);
        }
        if (className == null) {
            throw new IllegalArgumentException("Class name cannot be null");
        }
        this.className = className;
        this.superClass = superClass;
        this.classLoader = classLoader;
        this.protectionDomain = protectionDomain;
        this.classFile = classFactory == null ? new ClassFile(className, superClass.getName(), classLoader, new String[0]) : new ClassFile(className, superClass.getName(), classLoader, classFactory, new String[0]);
    }

    @Deprecated
    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader, ProtectionDomain protectionDomain) {
        this(className, superClass, classLoader, null, protectionDomain);
    }

    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader, ClassFactory classFactory) {
        this(className, superClass, classLoader, classFactory, null);
    }

    @Deprecated
    protected AbstractClassFactory(String className, Class<T> superClass, ClassLoader classLoader) {
        this(className, superClass, classLoader, null, null);
    }

    protected AbstractClassFactory(String className, Class<T> superClass, ClassFactory classFactory) {
        this(className, superClass, superClass.getClassLoader(), classFactory, null);
    }

    @Deprecated
    protected AbstractClassFactory(String className, Class<T> superClass) {
        this(className, superClass, superClass.getClassLoader(), null, null);
    }

    protected abstract void generateClass();

    protected abstract void cleanup();

    public void afterClassLoad(Class<?> clazz) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends T> defineClass() {
        if (this.generatedClass == null) {
            AbstractClassFactory abstractClassFactory = this;
            synchronized (abstractClassFactory) {
                if (this.generatedClass == null) {
                    try {
                        this.generatedClass = this.classLoader.loadClass(this.className);
                    }
                    catch (ClassNotFoundException e) {
                        this.buildClassDefinition();
                        this.generatedClass = this.protectionDomain == null ? this.classFile.define() : this.classFile.define(this.protectionDomain);
                        this.afterClassLoad(this.generatedClass);
                    }
                    this.classFile = null;
                }
            }
        }
        return this.generatedClass;
    }

    public boolean isProxyClassDefined() {
        return this.isProxyClassDefined(this.classLoader);
    }

    public boolean isProxyClassDefined(ClassLoader classLoader) {
        try {
            classLoader.loadClass(this.className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildClassDefinition() {
        if (!this.classGenerated) {
            AbstractClassFactory abstractClassFactory = this;
            synchronized (abstractClassFactory) {
                if (!this.classGenerated) {
                    this.generateClass();
                    this.cleanup();
                    this.classGenerated = true;
                }
            }
        }
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        return this.defineClass().newInstance();
    }

    public String getClassName() {
        return this.className;
    }

    public String getSuperClassName() {
        return this.superClass.getName();
    }

    public Class<T> getSuperClass() {
        return this.superClass;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }
}

