/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.exceptions.NotAuthorizedException;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntityType;
import org.apache.polaris.core.entity.PrincipalEntity;
import org.apache.polaris.core.persistence.PolarisMetaStoreManager;
import org.apache.polaris.core.persistence.dao.entity.EntityResult;
import org.apache.polaris.service.auth.DecodedToken;
import org.apache.polaris.service.auth.OAuthTokenErrorResponse;
import org.apache.polaris.service.auth.TokenBroker;
import org.apache.polaris.service.auth.TokenRequestValidator;
import org.apache.polaris.service.auth.TokenResponse;
import org.apache.polaris.service.types.TokenType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JWTBroker
implements TokenBroker {
    private static final Logger LOGGER = LoggerFactory.getLogger(JWTBroker.class);
    private static final String ISSUER_KEY = "polaris";
    private static final String CLAIM_KEY_ACTIVE = "active";
    private static final String CLAIM_KEY_CLIENT_ID = "client_id";
    private static final String CLAIM_KEY_PRINCIPAL_ID = "principalId";
    private static final String CLAIM_KEY_SCOPE = "scope";
    private final PolarisMetaStoreManager metaStoreManager;
    private final int maxTokenGenerationInSeconds;

    JWTBroker(PolarisMetaStoreManager metaStoreManager, int maxTokenGenerationInSeconds) {
        this.metaStoreManager = metaStoreManager;
        this.maxTokenGenerationInSeconds = maxTokenGenerationInSeconds;
    }

    public abstract Algorithm getAlgorithm();

    @Override
    public DecodedToken verify(String token) {
        JWTVerifier verifier = JWT.require((Algorithm)this.getAlgorithm()).withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(true)).build();
        try {
            final DecodedJWT decodedJWT = verifier.verify(token);
            return new DecodedToken(){

                @Override
                public Long getPrincipalId() {
                    return decodedJWT.getClaim(JWTBroker.CLAIM_KEY_PRINCIPAL_ID).asLong();
                }

                @Override
                public String getClientId() {
                    return decodedJWT.getClaim(JWTBroker.CLAIM_KEY_CLIENT_ID).asString();
                }

                @Override
                public String getSub() {
                    return decodedJWT.getSubject();
                }

                @Override
                public String getScope() {
                    return decodedJWT.getClaim(JWTBroker.CLAIM_KEY_SCOPE).asString();
                }
            };
        }
        catch (JWTVerificationException e) {
            LOGGER.error("Failed to verify the token with error", (Throwable)e);
            throw new NotAuthorizedException("Failed to verify the token", new Object[0]);
        }
    }

    @Override
    public TokenResponse generateFromToken(TokenType subjectTokenType, String subjectToken, String grantType, String scope, TokenType requestedTokenType) {
        DecodedToken decodedToken;
        if (requestedTokenType != null && !TokenType.ACCESS_TOKEN.equals((Object)requestedTokenType)) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.invalid_request);
        }
        if (!TokenType.ACCESS_TOKEN.equals((Object)subjectTokenType)) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.invalid_request);
        }
        if (StringUtils.isBlank((CharSequence)subjectToken)) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.invalid_request);
        }
        try {
            decodedToken = this.verify(subjectToken);
        }
        catch (NotAuthorizedException e) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.invalid_client);
        }
        EntityResult principalLookup = this.metaStoreManager.loadEntity(CallContext.getCurrentContext().getPolarisCallContext(), 0L, Objects.requireNonNull(decodedToken.getPrincipalId()).longValue(), PolarisEntityType.PRINCIPAL);
        if (!principalLookup.isSuccess() || principalLookup.getEntity().getType() != PolarisEntityType.PRINCIPAL) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.unauthorized_client);
        }
        String tokenString = this.generateTokenString(decodedToken.getClientId(), decodedToken.getScope(), decodedToken.getPrincipalId());
        return new TokenResponse(tokenString, TokenType.ACCESS_TOKEN.getValue(), this.maxTokenGenerationInSeconds);
    }

    @Override
    public TokenResponse generateFromClientSecrets(String clientId, String clientSecret, String grantType, String scope, PolarisCallContext polarisCallContext, TokenType requestedTokenType) {
        TokenRequestValidator validator = new TokenRequestValidator();
        Optional<OAuthTokenErrorResponse.Error> initialValidationResponse = validator.validateForClientCredentialsFlow(clientId, clientSecret, grantType, scope);
        if (initialValidationResponse.isPresent()) {
            return new TokenResponse(initialValidationResponse.get());
        }
        Optional<PrincipalEntity> principal = TokenBroker.findPrincipalEntity(this.metaStoreManager, clientId, clientSecret, polarisCallContext);
        if (principal.isEmpty()) {
            return new TokenResponse(OAuthTokenErrorResponse.Error.unauthorized_client);
        }
        String tokenString = this.generateTokenString(clientId, scope, principal.get().getId());
        return new TokenResponse(tokenString, TokenType.ACCESS_TOKEN.getValue(), this.maxTokenGenerationInSeconds);
    }

    private String generateTokenString(String clientId, String scope, Long principalId) {
        Instant now = Instant.now();
        return JWT.create().withIssuer(ISSUER_KEY).withSubject(String.valueOf(principalId)).withIssuedAt(now).withExpiresAt(now.plus((long)this.maxTokenGenerationInSeconds, ChronoUnit.SECONDS)).withJWTId(UUID.randomUUID().toString()).withClaim(CLAIM_KEY_ACTIVE, Boolean.valueOf(true)).withClaim(CLAIM_KEY_CLIENT_ID, clientId).withClaim(CLAIM_KEY_PRINCIPAL_ID, principalId).withClaim(CLAIM_KEY_SCOPE, this.scopes(scope)).sign(this.getAlgorithm());
    }

    @Override
    public boolean supportsGrantType(String grantType) {
        return TokenRequestValidator.ALLOWED_GRANT_TYPES.contains(grantType);
    }

    @Override
    public boolean supportsRequestedTokenType(TokenType tokenType) {
        return tokenType == null || TokenType.ACCESS_TOKEN.equals((Object)tokenType);
    }

    private String scopes(String scope) {
        return StringUtils.isNotBlank((CharSequence)scope) ? scope : "PRINCIPAL_ROLE:ALL";
    }
}

