/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import com.google.common.annotations.VisibleForTesting;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.polaris.core.exceptions.FileIOUnknownHostException;

public class ExceptionMappingFileIO
implements FileIO {
    private final FileIO io;

    public ExceptionMappingFileIO(FileIO io) {
        this.io = io;
    }

    private void handleException(RuntimeException e) {
        for (Throwable t : ExceptionUtils.getThrowables((Throwable)e)) {
            if (!(t instanceof UnknownHostException)) continue;
            throw new FileIOUnknownHostException("UnknownHostException during File IO", t);
        }
    }

    @VisibleForTesting
    public FileIO getInnerIo() {
        return this.io;
    }

    public InputFile newInputFile(String path) {
        try {
            return this.io.newInputFile(path);
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }

    public OutputFile newOutputFile(String path) {
        try {
            return this.io.newOutputFile(path);
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }

    public void deleteFile(String path) {
        try {
            this.io.deleteFile(path);
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }

    public Map<String, String> properties() {
        try {
            return this.io.properties();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }

    public void initialize(Map<String, String> properties) {
        try {
            this.io.initialize(properties);
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }

    public void close() {
        try {
            this.io.close();
        }
        catch (RuntimeException e) {
            this.handleException(e);
            throw e;
        }
    }
}

