/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.storage;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;

public interface StorageConfiguration {
    public static final Duration DEFAULT_TOKEN_LIFESPAN = Duration.ofHours(1L);

    public Optional<String> awsAccessKey();

    public Optional<String> awsSecretKey();

    public Optional<String> gcpAccessToken();

    public Optional<Duration> gcpAccessTokenLifespan();

    default public Supplier<StsClient> stsClientSupplier() {
        return this.stsClientSupplier(true);
    }

    default public Supplier<StsClient> stsClientSupplier(boolean withCredentials) {
        return Suppliers.memoize(() -> {
            StsClientBuilder stsClientBuilder = StsClient.builder();
            if (withCredentials) {
                stsClientBuilder.credentialsProvider(this.stsCredentials());
            }
            return (StsClient)stsClientBuilder.build();
        });
    }

    default public AwsCredentialsProvider stsCredentials() {
        if (this.awsAccessKey().isPresent() && this.awsSecretKey().isPresent()) {
            LoggerFactory.getLogger(StorageConfiguration.class).warn("Using hard-coded AWS credentials - this is not recommended for production");
            return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)this.awsAccessKey().get(), (String)this.awsSecretKey().get()));
        }
        return DefaultCredentialsProvider.create();
    }

    default public Supplier<GoogleCredentials> gcpCredentialsSupplier() {
        return Suppliers.memoize(() -> {
            if (this.gcpAccessToken().isEmpty()) {
                try {
                    return GoogleCredentials.getApplicationDefault();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to get GCP credentials", e);
                }
            }
            AccessToken accessToken = new AccessToken(this.gcpAccessToken().get(), new Date(Instant.now().plus(this.gcpAccessTokenLifespan().orElse(DEFAULT_TOKEN_LIFESPAN)).toEpochMilli()));
            return GoogleCredentials.create((AccessToken)accessToken);
        });
    }
}

