/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.service.task.TaskFileIOSupplier;
import org.apache.polaris.service.task.TaskHandler;
import org.apache.polaris.service.task.TaskUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCleanupTaskHandler
implements TaskHandler {
    public static final int MAX_ATTEMPTS = 3;
    public static final int FILE_DELETION_RETRY_MILLIS = 100;
    public final TaskFileIOSupplier fileIOSupplier;
    public final ExecutorService executorService;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileCleanupTaskHandler.class);

    public FileCleanupTaskHandler(TaskFileIOSupplier fileIOSupplier, ExecutorService executorService) {
        this.fileIOSupplier = fileIOSupplier;
        this.executorService = executorService;
    }

    @Override
    public abstract boolean canHandleTask(TaskEntity var1);

    @Override
    public abstract boolean handleTask(TaskEntity var1, CallContext var2);

    public CompletableFuture<Void> tryDelete(TableIdentifier tableId, FileIO fileIO, String baseFile, String file, Throwable e, int attempt) {
        if (e != null && attempt <= 3) {
            LOGGER.atWarn().addKeyValue("file", (Object)file).addKeyValue("attempt", (Object)attempt).addKeyValue("error", (Object)e.getMessage()).log("Error encountered attempting to delete file");
        }
        if (attempt > 3 && e != null) {
            return CompletableFuture.failedFuture(e);
        }
        return CompletableFuture.runAsync(() -> {
            if (TaskUtils.exists(file, fileIO)) {
                fileIO.deleteFile(file);
            } else {
                LOGGER.atInfo().addKeyValue("file", (Object)file).addKeyValue("baseFile", (Object)(baseFile != null ? baseFile : "")).addKeyValue("tableId", (Object)tableId).log("table file cleanup task scheduled, but data file doesn't exist");
            }
        }, this.executorService).exceptionallyComposeAsync(newEx -> {
            LOGGER.atWarn().addKeyValue("file", (Object)file).addKeyValue("tableIdentifier", (Object)tableId).addKeyValue("baseFile", (Object)(baseFile != null ? baseFile : "")).log("Exception caught deleting data file", newEx);
            return this.tryDelete(tableId, fileIO, baseFile, file, (Throwable)newEx, attempt + 1);
        }, CompletableFuture.delayedExecutor(100L, TimeUnit.MILLISECONDS, this.executorService));
    }
}

