/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.internal;

import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.internal.FallbackMethod;
import io.smallrye.faulttolerance.internal.KotlinSupport;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FallbackMethodCandidates {
    private final FallbackMethod withoutExceptionParam;
    private final Map<Class<?>, FallbackMethod> withExceptionParam;

    private FallbackMethodCandidates(Method withoutExceptionParam, List<Method> withExceptionParam) {
        this.withoutExceptionParam = FallbackMethod.withoutExceptionParameter(withoutExceptionParam);
        HashMap map = new HashMap();
        for (Method method : withExceptionParam) {
            int exceptionParameterPosition = method.getParameterCount() - 1;
            if (KotlinSupport.isSuspendingFunction(method)) {
                --exceptionParameterPosition;
            }
            map.put(method.getParameterTypes()[exceptionParameterPosition], FallbackMethod.withExceptionParameter(method, exceptionParameterPosition));
        }
        this.withExceptionParam = map;
    }

    public boolean isEmpty() {
        return this.withoutExceptionParam == null && this.withExceptionParam.isEmpty();
    }

    public FallbackMethod select(Class<? extends Throwable> exceptionType) {
        if (!this.withExceptionParam.isEmpty()) {
            for (Class<? extends Throwable> type = exceptionType; type != null; type = type.getSuperclass()) {
                FallbackMethod candidate = this.withExceptionParam.get(type);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return this.withoutExceptionParam;
    }

    public static FallbackMethodCandidates create(FaultToleranceOperation operation, boolean allowExceptionParam) {
        Method withoutExceptionParam = operation.getFallbackMethod();
        List<Method> withExceptionParam = Collections.emptyList();
        if (allowExceptionParam && operation.getFallbackMethodsWithExceptionParameter() != null) {
            withExceptionParam = operation.getFallbackMethodsWithExceptionParameter();
        }
        return new FallbackMethodCandidates(withoutExceptionParam, withExceptionParam);
    }
}

