/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.RESTResponse;

public class GetNamespaceResponse
implements RESTResponse {
    private Namespace namespace;
    private Map<String, String> properties;

    public GetNamespaceResponse() {
    }

    private GetNamespaceResponse(Namespace namespace, Map<String, String> properties) {
        this.namespace = namespace;
        this.properties = properties;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument((this.namespace != null ? 1 : 0) != 0, (Object)"Invalid namespace: null");
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public Map<String, String> properties() {
        return this.properties != null ? this.properties : ImmutableMap.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("properties", this.properties).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Namespace namespace;
        private final ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

        private Builder() {
        }

        public Builder withNamespace(Namespace ns) {
            Preconditions.checkNotNull((Object)ns, (Object)"Invalid namespace: null");
            this.namespace = ns;
            return this;
        }

        public Builder setProperties(Map<String, String> props) {
            Preconditions.checkNotNull(props, (Object)"Invalid properties map: null");
            Preconditions.checkArgument((!props.containsKey(null) ? 1 : 0) != 0, (Object)"Invalid property: null");
            Preconditions.checkArgument((!props.containsValue(null) ? 1 : 0) != 0, (String)"Invalid value for properties %s: null", Maps.filterValues(props, Objects::isNull).keySet());
            this.properties.putAll(props);
            return this;
        }

        public GetNamespaceResponse build() {
            return new GetNamespaceResponse(this.namespace, (Map<String, String>)this.properties.build());
        }
    }
}

