/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public final class Sets {
    private static final int MAX_POWER_OF_TWO = 0x40000000;

    private Sets() {
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet<E> set = Sets.newHashSetWithExpectedSize(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        return elements instanceof Collection ? new HashSet<E>(Sets.cast(elements)) : Sets.newHashSet(elements.iterator());
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet(Iterable<? extends E> elements) {
        TreeSet<E> set = Sets.newTreeSet();
        Sets.addAll(set, elements);
        return set;
    }

    private static <E extends Comparable> boolean addAll(TreeSet<E> addTo, Iterable<? extends E> elementsToAdd) {
        if (elementsToAdd instanceof Collection) {
            Collection<? extends E> c = Sets.cast(elementsToAdd);
            return addTo.addAll(c);
        }
        if (elementsToAdd == null) {
            throw new NullPointerException();
        }
        return Sets.addAll(addTo, elementsToAdd.iterator());
    }

    public static <E> HashSet<E> newHashSet(Iterator<? extends E> elements) {
        HashSet<E> set = Sets.newHashSet();
        Sets.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(Sets.capacity(expectedSize));
    }

    private static <E> Collection<E> cast(Iterable<E> iterable) {
        return (Collection)iterable;
    }

    private static <E> boolean addAll(Collection<E> addTo, Iterator<? extends E> iterator) {
        if (addTo == null) {
            throw new NullPointerException();
        }
        if (iterator == null) {
            throw new NullPointerException();
        }
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return wasModified;
    }

    public static <E> Set<E> intersection(Set<E> set1, Set<E> set2) {
        if (set1 == null) {
            throw new NullPointerException("set1");
        }
        if (set2 == null) {
            throw new NullPointerException("set2");
        }
        HashSet<E> newSet = new HashSet<E>(set1);
        newSet.retainAll(set2);
        return Collections.unmodifiableSet(newSet);
    }

    public static <E> Set<E> union(Set<E> set1, Set<E> set2) {
        if (set1 == null) {
            throw new NullPointerException("set1");
        }
        if (set2 == null) {
            throw new NullPointerException("set2");
        }
        HashSet<E> newSet = new HashSet<E>(set1);
        newSet.addAll(set2);
        return Collections.unmodifiableSet(newSet);
    }

    public static <E> Set<E> difference(Set<E> set1, Set<E> set2) {
        if (set1 == null) {
            throw new NullPointerException("set1");
        }
        if (set2 == null) {
            throw new NullPointerException("set2");
        }
        HashSet<E> newSet = new HashSet<E>(set1);
        newSet.removeAll(set2);
        return Collections.unmodifiableSet(newSet);
    }

    public static <E> Set<E> differenceInTreeSets(Set<E> set1, Set<E> set2) {
        if (set1 == null) {
            throw new NullPointerException("set1");
        }
        if (set2 == null) {
            throw new NullPointerException("set2");
        }
        TreeSet<E> newSet = new TreeSet<E>(set1);
        newSet.removeAll(set2);
        return Collections.unmodifiableSet(newSet);
    }

    public static <E> Set<E> symmetricDifference(Set<E> set1, Set<E> set2) {
        if (set1 == null) {
            throw new NullPointerException("set1");
        }
        if (set2 == null) {
            throw new NullPointerException("set2");
        }
        HashSet<E> intersection = new HashSet<E>(set1);
        intersection.retainAll(set2);
        HashSet<E> symmetricDifference = new HashSet<E>(set1);
        symmetricDifference.addAll(set2);
        symmetricDifference.removeAll(intersection);
        return Collections.unmodifiableSet(symmetricDifference);
    }

    public static <E> Set<E> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    private static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            if (expectedSize < 0) {
                throw new IllegalArgumentException("expectedSize cannot be negative but was: " + expectedSize);
            }
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            return (int)((float)expectedSize / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }
}

