/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.LinkedHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.math.NumberUtils;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FederationQueueWeight {
    private static final String COMMA = ",";
    private static final String COLON = ":";

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static FederationQueueWeight newInstance(String routerWeight, String amrmWeight, String headRoomAlpha) {
        FederationQueueWeight federationQueueWeight = Records.newRecord(FederationQueueWeight.class);
        federationQueueWeight.setRouterWeight(routerWeight);
        federationQueueWeight.setAmrmWeight(amrmWeight);
        federationQueueWeight.setHeadRoomAlpha(headRoomAlpha);
        return federationQueueWeight;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static FederationQueueWeight newInstance(String routerWeight, String amrmWeight, String headRoomAlpha, String queue, String policyManagerClassName) {
        FederationQueueWeight federationQueueWeight = Records.newRecord(FederationQueueWeight.class);
        federationQueueWeight.setRouterWeight(routerWeight);
        federationQueueWeight.setAmrmWeight(amrmWeight);
        federationQueueWeight.setHeadRoomAlpha(headRoomAlpha);
        federationQueueWeight.setQueue(queue);
        federationQueueWeight.setPolicyManagerClassName(policyManagerClassName);
        return federationQueueWeight;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getRouterWeight();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setRouterWeight(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getAmrmWeight();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setAmrmWeight(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getHeadRoomAlpha();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setHeadRoomAlpha(String var1);

    public static void checkSubClusterQueueWeightRatioValid(String subClusterWeight) throws YarnException {
        boolean isValid;
        if (StringUtils.isBlank((CharSequence)subClusterWeight)) {
            throw new YarnException("subClusterWeight can't be empty!");
        }
        String[] subClusterWeights = subClusterWeight.split(COMMA);
        LinkedHashMap<String, Double> subClusterWeightMap = new LinkedHashMap<String, Double>();
        for (String subClusterWeightItem : subClusterWeights) {
            String[] subClusterWeightItems = subClusterWeightItem.split(COLON);
            if (subClusterWeightItems == null || subClusterWeightItems.length != 2) {
                throw new YarnException("The subClusterWeight cannot be empty, and the subClusterWeight size must be 2. (eg.SC-1,0.2)");
            }
            subClusterWeightMap.put(subClusterWeightItems[0], Double.valueOf(subClusterWeightItems[1]));
        }
        double sum = subClusterWeightMap.values().stream().mapToDouble(Double::doubleValue).sum();
        boolean bl = isValid = Math.abs(sum - 1.0) < 1.0E-6;
        if (!isValid) {
            throw new YarnException("The sum of ratios for all subClusters must be equal to 1.");
        }
    }

    public static void checkHeadRoomAlphaValid(String headRoomAlpha) throws YarnException {
        if (!FederationQueueWeight.isNumeric(headRoomAlpha)) {
            throw new YarnException("HeadRoomAlpha must be a number.");
        }
        double dHeadRoomAlpha = Double.parseDouble(headRoomAlpha);
        if (!(dHeadRoomAlpha >= 0.0) || !(dHeadRoomAlpha <= 1.0)) {
            throw new YarnException("HeadRoomAlpha must be between 0-1.");
        }
    }

    protected static boolean isNumeric(String value) {
        return NumberUtils.isCreatable((String)value);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getQueue();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getPolicyManagerClassName();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setPolicyManagerClassName(String var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FederationQueueWeight { ");
        builder.append("Queue: ").append(this.getQueue()).append(", ");
        builder.append("RouterWeight: ").append(this.getRouterWeight()).append(", ");
        builder.append("AmrmWeight: ").append(this.getAmrmWeight()).append(", ");
        builder.append("PolicyManagerClassName: ").append(this.getPolicyManagerClassName());
        builder.append(" }");
        return builder.toString();
    }
}

