/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;

public class ScanTaskUtil {
    private ScanTaskUtil() {
    }

    public static long contentSizeInBytes(ContentFile<?> file) {
        if (file.content() == FileContent.DATA) {
            return file.fileSizeInBytes();
        }
        DeleteFile deleteFile = (DeleteFile)file;
        return ScanTaskUtil.isDV(deleteFile) ? deleteFile.contentSizeInBytes().longValue() : deleteFile.fileSizeInBytes();
    }

    public static long contentSizeInBytes(Iterable<? extends ContentFile<?>> files) {
        long size = 0L;
        for (ContentFile<?> file : files) {
            size += ScanTaskUtil.contentSizeInBytes(file);
        }
        return size;
    }

    private static boolean isDV(DeleteFile deleteFile) {
        return deleteFile.format() == FileFormat.PUFFIN;
    }
}

