/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.connection;

import jakarta.annotation.Nonnull;
import java.util.Arrays;

public enum ConnectionType {
    NULL_TYPE(0),
    ICEBERG_REST(1),
    HADOOP(2);

    private static final ConnectionType[] REVERSE_MAPPING_ARRAY;
    private final int code;

    private ConnectionType(int code) {
        this.code = code;
    }

    @Nonnull
    public static ConnectionType fromCode(int connectionTypeCode) {
        if (connectionTypeCode < 0 || connectionTypeCode >= REVERSE_MAPPING_ARRAY.length) {
            return NULL_TYPE;
        }
        return REVERSE_MAPPING_ARRAY[connectionTypeCode];
    }

    public int getCode() {
        return this.code;
    }

    static {
        int maxCode = Arrays.stream(ConnectionType.values()).mapToInt(ConnectionType::getCode).max().orElse(0);
        REVERSE_MAPPING_ARRAY = new ConnectionType[maxCode + 1];
        ConnectionType[] connectionTypeArray = ConnectionType.values();
        int n = connectionTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ConnectionType connectionType;
            ConnectionType.REVERSE_MAPPING_ARRAY[connectionType.code] = connectionType = connectionTypeArray[i];
        }
    }
}

