/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;

public class PolarisResolvedPathWrapper {
    private final List<ResolvedPolarisEntity> resolvedPath;

    public PolarisResolvedPathWrapper(List<ResolvedPolarisEntity> resolvedPath) {
        this.resolvedPath = resolvedPath;
    }

    public ResolvedPolarisEntity getResolvedLeafEntity() {
        if (this.resolvedPath == null || this.resolvedPath.isEmpty()) {
            return null;
        }
        return this.resolvedPath.get(this.resolvedPath.size() - 1);
    }

    public PolarisEntity getRawLeafEntity() {
        ResolvedPolarisEntity resolvedEntity = this.getResolvedLeafEntity();
        if (resolvedEntity != null) {
            return resolvedEntity.getEntity();
        }
        return null;
    }

    public List<ResolvedPolarisEntity> getResolvedFullPath() {
        return this.resolvedPath;
    }

    public List<PolarisEntity> getRawFullPath() {
        if (this.resolvedPath == null) {
            return null;
        }
        return this.resolvedPath.stream().map(ResolvedPolarisEntity::getEntity).collect(Collectors.toList());
    }

    public List<ResolvedPolarisEntity> getResolvedParentPath() {
        if (this.resolvedPath == null) {
            return null;
        }
        return this.resolvedPath.subList(0, this.resolvedPath.size() - 1);
    }

    public List<PolarisEntity> getRawParentPath() {
        if (this.resolvedPath == null) {
            return null;
        }
        return this.getResolvedParentPath().stream().map(ResolvedPolarisEntity::getEntity).collect(Collectors.toList());
    }

    public String toString() {
        return "resolvedPath:" + String.valueOf(this.resolvedPath);
    }
}

