/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.persistence.dao.entity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.polaris.core.entity.PolarisBaseEntity;
import org.apache.polaris.core.entity.PolarisEntityCore;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.core.persistence.dao.entity.BaseResult;

public class LoadGrantsResult
extends BaseResult {
    private final int grantsVersion;
    private final List<PolarisGrantRecord> grantRecords;
    private final List<PolarisBaseEntity> entities;

    public LoadGrantsResult(@Nonnull BaseResult.ReturnStatus errorCode, @Nullable String extraInformation) {
        super(errorCode, extraInformation);
        this.grantsVersion = 0;
        this.grantRecords = null;
        this.entities = null;
    }

    public LoadGrantsResult(int grantsVersion, @Nonnull List<PolarisGrantRecord> grantRecords, List<PolarisBaseEntity> entities) {
        super(BaseResult.ReturnStatus.SUCCESS);
        this.grantsVersion = grantsVersion;
        this.grantRecords = grantRecords;
        this.entities = entities;
    }

    @JsonCreator
    private LoadGrantsResult(@JsonProperty(value="returnStatus") @Nonnull BaseResult.ReturnStatus returnStatus, @JsonProperty(value="extraInformation") String extraInformation, @JsonProperty(value="grantsVersion") int grantsVersion, @JsonProperty(value="grantRecords") List<PolarisGrantRecord> grantRecords, @JsonProperty(value="entities") List<PolarisBaseEntity> entities) {
        super(returnStatus, extraInformation);
        this.grantsVersion = grantsVersion;
        this.grantRecords = grantRecords;
        this.entities = entities;
    }

    public int getGrantsVersion() {
        return this.grantsVersion;
    }

    public List<PolarisGrantRecord> getGrantRecords() {
        return this.grantRecords;
    }

    public List<PolarisBaseEntity> getEntities() {
        return this.entities;
    }

    @JsonIgnore
    public Map<Long, PolarisBaseEntity> getEntitiesAsMap() {
        return this.getEntities() == null ? null : this.getEntities().stream().collect(Collectors.toMap(PolarisEntityCore::getId, entity -> entity));
    }

    public String toString() {
        return "LoadGrantsResult{grantsVersion=" + this.grantsVersion + ", grantRecords=" + String.valueOf(this.grantRecords) + ", entities=" + String.valueOf(this.entities) + ", returnStatus=" + String.valueOf((Object)this.getReturnStatus()) + "}";
    }
}

