/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.storage.cache;

import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;
import org.apache.polaris.core.PolarisCallContext;
import org.apache.polaris.core.context.CallContext;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.PolarisEntityConstants;

public class StorageCredentialCacheKey {
    private final long catalogId;
    private final String storageConfigSerializedStr;
    private final long entityId;
    private final boolean allowedListAction;
    private final Set<String> allowedReadLocations;
    private final Set<String> allowedWriteLocations;
    @Nullable
    private PolarisCallContext callContext;

    public StorageCredentialCacheKey(PolarisEntity entity, boolean allowedListAction, Set<String> allowedReadLocations, Set<String> allowedWriteLocations, @Nullable PolarisCallContext callContext) {
        this.catalogId = entity.getCatalogId();
        this.storageConfigSerializedStr = entity.getInternalPropertiesAsMap().get(PolarisEntityConstants.getStorageConfigInfoPropertyName());
        this.entityId = entity.getId();
        this.allowedListAction = allowedListAction;
        this.allowedReadLocations = allowedReadLocations;
        this.allowedWriteLocations = allowedWriteLocations;
        this.callContext = callContext;
        if (this.callContext == null) {
            this.callContext = CallContext.getCurrentContext().getPolarisCallContext();
        }
    }

    public long getCatalogId() {
        return this.catalogId;
    }

    public String getStorageConfigSerializedStr() {
        return this.storageConfigSerializedStr;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public boolean isAllowedListAction() {
        return this.allowedListAction;
    }

    public Set<String> getAllowedReadLocations() {
        return this.allowedReadLocations;
    }

    public Set<String> getAllowedWriteLocations() {
        return this.allowedWriteLocations;
    }

    @Nullable
    public PolarisCallContext getCallContext() {
        return this.callContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageCredentialCacheKey cacheKey = (StorageCredentialCacheKey)o;
        return this.catalogId == cacheKey.getCatalogId() && Objects.equals(this.storageConfigSerializedStr, cacheKey.getStorageConfigSerializedStr()) && this.allowedListAction == cacheKey.allowedListAction && Objects.equals(this.allowedReadLocations, cacheKey.allowedReadLocations) && Objects.equals(this.allowedWriteLocations, cacheKey.allowedWriteLocations);
    }

    public int hashCode() {
        return Objects.hash(this.catalogId, this.storageConfigSerializedStr, this.allowedListAction, this.allowedReadLocations, this.allowedWriteLocations);
    }

    public String toString() {
        return "StorageCredentialCacheKey{catalogId=" + this.catalogId + ", storageConfigSerializedStr='" + this.storageConfigSerializedStr + "', entityId=" + this.entityId + ", allowedListAction=" + this.allowedListAction + ", allowedReadLocations=" + String.valueOf(this.allowedReadLocations) + ", allowedWriteLocations=" + String.valueOf(this.allowedWriteLocations) + "}";
    }
}

